package com.bxm.egg.user.login;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.LoginParam;

/**
 * 用户行为日志服务
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/16 10:20 上午
 */
public interface UserLogService {

    /**
     * 记录用户注册记录
     *
     * @param newUser 新用户信息
     * @param param   登录入参
     */
    void recordRegisterLog(UserInfoEntity newUser, LoginParam param);

    /**
     * 记录用户登录记录
     *
     * @param loginParam        登录参数
     * @param resultDTO         登录结果
     * @param userLoginTypeEnum 登录类型
     */
    void recordLoginLog(LoginParam loginParam,
                        LoginResultDTO resultDTO,
                        UserLoginTypeEnum userLoginTypeEnum);
}