package com.bxm.egg.user.login.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.user.mapper.UserLoginHistoryMapper;
import com.bxm.egg.user.login.UserLoginHistoryService;
import com.bxm.egg.user.model.vo.UserLoginHistory;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.enums.PlatformEnum;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

@Slf4j
@Service
public class UserLoginHistoryServiceImpl implements UserLoginHistoryService {

    @Resource
    private UserLoginHistoryMapper userLoginHistoryMapper;

    @Async
    @Override
    public void save(UserLoginHistory userLoginHistory) {
        userLoginHistoryMapper.insertSelective(userLoginHistory);
    }

    @Override
    public Message isDeviceExist(Long userId, String deviceId) {
        if (null != deviceId) {
            List<UserLoginHistory> userLoginHistoryList = userLoginHistoryMapper.selectUserByEquipment(userId, deviceId);
            if (CollectionUtils.isEmpty(userLoginHistoryList)) {
                return Message.build(false).addParam("equipment", deviceId);
            } else {
                return Message.build(true).addParam("equipment", deviceId);
            }
        }
        return Message.build(true);
    }

    @Override
    public Message isDeviceExistByDeviceId(Long userId, String deviceId) {
        if (null == userId || StringUtils.isEmpty(deviceId)) {
            return Message.build(true);
        }
        List<UserLoginHistory> userLoginHistoryList = userLoginHistoryMapper.selectUserByEquipment(userId, deviceId);
        return Message.build(CollectionUtils.isEmpty(userLoginHistoryList));
    }

    @Override
    @Async
    public void save(String equipment, BasicParam basicParam, Long userId, String ip) {
        //8.保存用户登录信息(客户端时可以获取到设备信息的，另外的不行)
        if (PlatformEnum.ANDROID.getCode() == basicParam.getPlatform()
                || PlatformEnum.IOS.getCode() == basicParam.getPlatform()) {

            if (log.isDebugEnabled()) {
                log.debug("更新登录历史，devcId:[{}],equipment:[{}]", basicParam.getDevcId(), JSONObject.toJSON(equipment));
            }

            if (com.bxm.newidea.component.tools.StringUtils.isNoneEmpty(equipment)) {
                this.save(UserLoginHistory.buildUserLoginHistory(SequenceHolder.nextLongId(), userId, ip, equipment));
            }
        } else if (4 == basicParam.getPlatform() || PlatformEnum.APPLET.getCode() == basicParam.getPlatform()) {
            //大转盘和小程序都是获取不到设备信息的，所以固定存传过来的devcid就行，值为2
            this.save(UserLoginHistory.buildUserLoginHistory(SequenceHolder.nextLongId(), userId, ip, String.valueOf(basicParam.getDevcId())));
        }
    }

    @Override
    public UserLoginHistory selectFirst(Long userId) {
        return userLoginHistoryMapper.selectFirstOrLastOne(userId, 0);
    }

    @Override
    public UserLoginHistory selectLast(Long userId) {
        return userLoginHistoryMapper.selectFirstOrLastOne(userId, 1);
    }
}
