package com.bxm.egg.user.medal.msg.listener;

import com.bxm.egg.user.medal.msg.UserMedalProcessor;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

import static com.bxm.egg.user.constant.RedisConfig.MEDAL_REFRESH_MSG_LIST;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/3/5 6:26 下午
 */
@Slf4j
@Component
@EnableBinding(UserMedalProcessor.class)
@AllArgsConstructor
public class UserMedalCounterListenerService {

    private RedisSetAdapter redisSetAdapter;

    /**
     * 监听binding中的消息
     */
    @StreamListener(UserMedalProcessor.USER_MEDAL_INPUT)
    public void handleHotPostJoinEvent(UserMedalCounterDTO userMedalCounterDTO) {
        log.info("监听到用户改变勋章统计数据消息：{}", JSON.toJSONString(userMedalCounterDTO));

        redisSetAdapter.add(buildMedalMsgList(), JSON.toJSONString(userMedalCounterDTO));
    }

    private KeyGenerator buildMedalMsgList() {
        return MEDAL_REFRESH_MSG_LIST.copy();
    }
}