package com.bxm.egg.user.onekey.impl;

import com.bxm.egg.user.onekey.JiGuangFlashService;
import com.bxm.egg.user.onekey.OneKeyService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/14 8:19 下午
 */
@Slf4j
@Service
public class OneKeyServiceImpl implements OneKeyService {
    @Resource
    private JiGuangFlashService jiGuangFlashService;

    @Override
    public Message checkToken(String token) {

        String phone = jiGuangFlashService.getPhone(token);

        if (StringUtils.isBlank(phone)) {
            return Message.build(false, "一键登录失败");
        }

        Message resultMsg = Message.build(true);
        resultMsg.addParam("phone", phone);
        return resultMsg;
    }
}