package com.bxm.egg.user.timer;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.egg.user.medal.UserMedalCounterService;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import lombok.extern.slf4j.Slf4j;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

import static com.bxm.egg.user.constant.RedisConfig.MEDAL_REFRESH_MSG_LIST;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/20 9:54 下午
 */
@Component
@Slf4j
public class MedalHandleTask implements ISimplifyElasticJob {

    @Resource
    private UserMedalCounterService userMedalCounterService;

    @Resource
    private RedisSetAdapter redisSetAdapter;

    @Resource
    private UserProperties userProperties;

    @Override
    public void execute(ShardingContext shardingContext) {
        if (log.isDebugEnabled()) {
            log.debug("处理勋章数据消息定时任务==========");
        }
        int cycleNum = 0;
        //最大循环次数
        int maxCycleNum = 5;
        List<UserMedalCounterDTO> userMedalMsgList = Collections.EMPTY_LIST;
        do {
            userMedalMsgList = redisSetAdapter.pop(buildMedalMsgList(), userProperties.getHandleMedalMsgSpeech(), UserMedalCounterDTO.class);
            cycleNum++;

            for (UserMedalCounterDTO userMedalCounterDTO : userMedalMsgList) {
                userMedalCounterService.handleMedalCounterData(userMedalCounterDTO);
            }
        }
        while (userMedalMsgList.size() > userProperties.getHandleMedalMsgSpeech() && cycleNum < maxCycleNum);

        if (cycleNum >= maxCycleNum) {
            log.error("处理勋章消息队列数据时循环超过五次，需要注意！! !");
        }
    }

    private KeyGenerator buildMedalMsgList() {
        return MEDAL_REFRESH_MSG_LIST.copy();
    }

    @Override
    public String cron() {
        return "0 0/2 * * * ?";
    }

    @Override
    public String description() {
        return "处理勋章数据消息";
    }
}