package com.bxm.egg.user.attribute;

import com.bxm.egg.user.model.dto.UserVisitDTO;
import com.bxm.egg.user.model.param.UserVisitParam;

import java.util.Date;
import java.util.List;

/**
 * 用户访客服务类
 *
 * @author wzy
 * @date 2021年09月26日13:40:05
 */
public interface UserVisitService {

    /**
     * 用途：查询某个用户的访客记录列表，根据日期进行分页，如一次性查询3个日期的访客记录。
     * 每次查询得到的访客记录数量是不定的，因为每个日期的访客记录数量是不定的
     * 场景：用户的主态个人页可以点击<最近访客>得到最近的访客记录
     *
     * @param userVisitParam 用户访客传参实体
     * @return 访客列表
     */
    List<UserVisitDTO> listUserVisit(UserVisitParam userVisitParam);

    /**
     * 访问接口
     *
     * @param userId       当前用户id
     * @param targetUserId 被访问用户id
     * @return 是否成功
     */
    void visit(Long userId, Long targetUserId);

    /**
     * 虚拟用户访问接口
     *
     * @param userId 被访问用户id
     * @param num    访问数
     */
    void virtualVisit(Long userId, Integer num);

    /**
     * 用途：根据用户id获取最近访客列表的头像，如没有则为空list
     */
    List<String> listRecentVisitorHeadImg(Long userId);

    /**
     * 用途：根据用户id获取当天的访问数（去重），如没有则为0
     */
    Integer getTodayVisitorNum(Long userId);

    /**
     * 用途：更新用户访问表中的用户冗余信息 在用户更改信息后需要同步至用户访问表
     */
    void doTriggerUpdateInfo(Long userId, String nickname, String headImg, Byte sex);

    /**
     * 用途：得到用户的总访问量
     */
    Integer getInterviewNumByUserId(Long userId);

    /**
     * 用途：得到用户在指定日期之前的总访问量 场景：在用户每天第一次打开app的时候，会查询上次退出到这次登录期间有多少人看过该用户的主页，并发送消息
     */
    Integer getInterviewNumByTime(Long userId, Date date);
}
