package com.bxm.egg.user.facade;

import com.bxm.egg.user.facade.dto.UserWarmValueUpDTO;
import com.bxm.egg.user.facade.param.UserWarmActionParam;
import com.bxm.egg.user.facade.service.UserWarmFacadeService;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.egg.user.warmlevel.impl.WarmHandlerProxy;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

import javax.annotation.Resource;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 5:24 下午
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
public class UserWarmFacadeServiceImpl implements UserWarmFacadeService {

    @Resource
    private UserWarmLevelService userWarmLevelService;

    @Resource
    private WarmHandlerProxy warmHandlerProxy;

    @Override
    public Boolean updateWarm(UserWarmActionParam param) {
        warmHandlerProxy.handle(param);
        return true;
    }

    @Override
    public UserWarmValueUpDTO getUserLevelPopData(Long userId) {
        return userWarmLevelService.getUserLevelPopData(userId);
    }
}