package com.bxm.egg.user.info;

import com.bxm.egg.user.model.dto.UserBaseInfoDTO;
import com.bxm.egg.user.model.dto.info.UserBindWxDTO;
import com.bxm.egg.user.model.dto.info.UserBriefInfoDTO;
import com.bxm.egg.user.model.dto.info.UserDetailInfoDTO;

import java.util.List;
import java.util.Map;

/**
 * 获取用户基础信息service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 10:39 上午
 */
public interface UserBaseInfoService {

    /**
     * 获取简易用户信息
     *
     * @param userIdList 用户id列表
     * @return 用户简易信息
     */
    List<UserBriefInfoDTO> getUserBriefInfoList(List<Long> userIdList);

    /**
     * 获取用户详细信息
     *
     * @param userIdList 用户id列表
     * @return 用户详细信息列表
     */
    List<UserDetailInfoDTO> getUserDetailInfoList(List<Long> userIdList);


    /**
     * 用途：获取个人中心页面用户的信息【我的】
     *
     * @param userId 用户id
     * @return 我的页面相关信息
     */
    UserBaseInfoDTO getUserPersonalCenterInfo(Long userId);


    /**
     * 获取简易用户信息
     *
     * @param userId 用户id
     * @return 用户简易信息
     */
    UserBriefInfoDTO getSingleUserBriefInfo(Long userId);

    /**
     * 获取用户详细信息
     *
     * @param userId 用户id
     * @return 用户详细信息列表
     */
    UserDetailInfoDTO getSingleUserDetailInfo(Long userId);

    /**
     * 获取简略用户信息映射
     *
     * @param userIdList 用户id列表
     * @return 简略用户信息映射
     */
    Map<Long, UserBriefInfoDTO> getUserBriefMapInfo(List<Long> userIdList);

    /**
     * 获取详细信息映射
     *
     * @param userIdList 用户列表
     * @return 详细用户信息映射
     */
    Map<Long, UserDetailInfoDTO> getUserDetailMapInfo(List<Long> userIdList);
}