package com.bxm.egg.user.invite;

import com.bxm.egg.user.model.dto.UserInfoDTO;
import com.bxm.egg.user.model.vo.InviteRecord;
import com.bxm.newidea.component.param.BasicParam;
import lombok.Data;
import lombok.ToString;

/**
 * 邀请处理器的上下文
 *
 * @author liujia
 * @date 2020/05/11 17:43
 */
@ToString
@Data
public class InviteProcessorContext {
    /**
     * 当前邀请记录
     */
    private InviteRecord record;

    /**
     * 被邀请用户信息
     */
    private UserInfoDTO invitedUser;

    /**
     * 基础参数，可能为空
     */
    private BasicParam basicParam;

    /**
     * 当前邀请关系是否为有效性邀请
     * true：表示有效要求，有部分场景只有有效要求才会派发奖励
     */
    private boolean effective;

    /**
     * 师傅的师傅id
     */
    private Long inviteSuperUserId;

    /**
     * 师傅的师傅分享的文章创作人id
     */
    private Long inviteCreatedUserId;

    /**
     * 师傅分享的帖子创作人id
     */
    private Long createdUserId;

    /**
     * 直系徒弟：就是靠他建立的师徒关系
     */
    private Long inviteUserId;

    /**
     * 直系徒弟的名称
     */
    private String inviteUserName;

    /**
     * 被邀人的设备编号，用于处理和设备维度有关的逻辑
     */
    private String invitedEquipment;

    private Long relationId;

    /**
     * 新用户登录时的IP
     */
    private String loginIp;

    /**
     * 获取当前邀请关系绑定的关联业务ID
     *
     * @return 关联的业务ID，根据具体的邀请类型来解释该值
     */
    public Long getRelationId() {
        if (null != relationId) {
            return relationId;
        }

        if (null != invitedUser) {
            return invitedUser.getRelationId();
        }
        return null;
    }

    /**
     * 获取被邀请人的用户ID
     *
     * @return 被邀请人的用户ID
     */
    public Long getInvitedUserId() {
        return record.getInvitedUserId();
    }

    /**
     * 获取发起邀请的用户ID
     *
     * @return 发起邀请的用户ID
     */
    public Long getUserId() {
        return record.getUserId();
    }
}
