package com.bxm.egg.user.invite;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.bo.Message;

/**
 * 邀请类型对应的处理器，处理不同的邀请逻辑成立时的各种相关逻辑
 *
 * @author liujia
 * @date 2020/05/11 15:24
 */
public interface InviteTypeProcessor {
    /**
     * 每一种处理器对应的邀请类型
     *
     * @return 当前处理器支持的邀请类型
     */
    InviteTypeEnum support();

    /**
     * 装饰邀请信息的标题，作为最终显示到前端的标题
     * 不同的邀请类型显示文案有所区别，详见产品需求
     *
     * @param inviteHistory 邀请记录历史
     * @return 装饰后的标题
     */
    String decorateTitle(UserInviteHistoryBean inviteHistory);

    /**
     * 邀请成功后的处理器逻辑
     *
     * @param context 邀请信息上下文
     * @return 处理结果
     */
    Message afterInvited(InviteProcessorContext context);

    /**
     * 获取邀请类型对应的显示标题
     * 邀请时仅记录了相关的业务ID
     * 3.2.0版本开始需要显示具体的邀请途径，需要通过不同的邀请类型显示对应的标题
     *
     * @param context 邀请记录上下文信息
     * @return 邀请记录显示的标题
     */
    String obtainTitle(InviteProcessorContext context);


}
