package com.bxm.egg.user.invite.processor;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.invite.InviteProcessorContext;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.bo.Message;
import org.springframework.stereotype.Component;

/**
 * 通过分析商户信息进行邀请
 *
 * @author liujia
 * @date 2020/05/12 14:10
 */
@Component
public class MerchantInviteTypeProcessor extends AbstractInviteTypeProcessor {
    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return "商户信息";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.MERCHANT;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "分享的" + inviteHistory.getRelationTitle();
    }
}
