package com.bxm.egg.user.location.event;

import com.bxm.egg.user.constant.UserLocationTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/17 7:05 下午
 */
@Data
@Builder
@AllArgsConstructor
public class UserLocationChangeEvent {

    @Tolerate
    public UserLocationChangeEvent() {

    }

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("地区简称")
    private String areaName;

    @ApiModelProperty("经度")
    private BigDecimal lng;

    @ApiModelProperty("纬度")
    private BigDecimal lat;

    @ApiModelProperty("定位类型")
    private UserLocationTypeEnum locationType;
}