package com.bxm.egg.user.location.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.component.bus.annotations.EventBusSubscriber;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.location.event.UserLocationReportEvent;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 用户定位上报监听器
 *
 * @author wzy
 * @version 1.0
 * @date 2021/10/27 1:51 下午
 */
@Slf4j
@Component
@AllArgsConstructor
public class UserLocationReportListener {

    private UserLocationService userLocationService;

    @EventBusSubscriber
    @Async
    public void userLocationInfoReportEvent(UserLocationReportEvent event) {

        if (log.isDebugEnabled()) {
            log.debug("监听到用户位置更改上报：{}", JSON.toJSONString(event));
        }

        if (Objects.nonNull(event.getUserId()) &&
                Objects.nonNull(event.getLat()) &&
                Objects.nonNull(event.getLng())) {

            UserLocationEntity userLocationInfo = userLocationService.getUserLocationByUserId(event.getUserId());

            if (userLocationInfo == null) {
                log.error("用户定位上报监听器，用户定位信息为空，事件内容：{}", JSON.toJSONString(event));
                return;
            }

            if (log.isDebugEnabled()) {
                log.debug("用户id:{}, 库中用户经度：{}, 库中用户纬度：{}，" +
                                "更新后经度：{}, 更新后纬度：{}",
                        event.getUserId(), userLocationInfo.getLastLng(), userLocationInfo.getLastLat(),
                        event.getLng(), event.getLat());
            }
            if (!Objects.equals(event.getLat(), userLocationInfo.getLastLat())
                    || !Objects.equals(event.getLng(), userLocationInfo.getLastLng())) {

                UserLocationEntity updateLocationEntity = new UserLocationEntity();

                updateLocationEntity.setUserId(event.getUserId());
                updateLocationEntity.setLastLat(event.getLat());
                updateLocationEntity.setLastLng(event.getLng());

                //更新用户经纬度
                userLocationService.updateUserLocationInfo(event.getUserId(), updateLocationEntity);
            }
        }
    }
}