package com.bxm.egg.user.location.rule;

import com.bxm.egg.user.constant.OrderConstant;
import com.bxm.egg.user.constant.SwitchType;
import com.bxm.egg.user.constant.UserBizConfigProperties;
import com.bxm.egg.user.location.context.LocationSwitchContext;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import lombok.AllArgsConstructor;

import static com.bxm.egg.user.constant.LogicGroup.LOCATION_SWITCH_RULE;


/**
 * 所有的定位都失败，进行强制定位
 * 根据配置，返回默认的定位
 *
 * @author liujia
 * @date 10/29/21 10:17 AM
 **/
@RuleBean(group = LOCATION_SWITCH_RULE)
@AllArgsConstructor
public class ForceLocationRule implements IRule<LocationSwitchContext> {

    private UserBizConfigProperties userBizConfigProperties;

    @Override
    public boolean apply(LocationSwitchContext context) {
        context.setFinalSwitchType(SwitchType.FORCE_SWITCH);
        context.setFinalAreaCode(userBizConfigProperties.getDefaultLocation());
        context.setMatchRuleClass(this.getClass());
        return false;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
