package com.bxm.egg.user.login.strategy.support;

import com.bxm.egg.mq.common.constant.SmsTemplateEnum;
import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.SmsIntegrationService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.PhoneAppLoginParam;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Optional;

/**
 * 验证码方式登录
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/14 8:02 下午
 */
@Slf4j
@Service
public class SmsLoginStrategy extends AbstractUserLoginStrategy<PhoneAppLoginParam> {

    @Resource
    private SmsIntegrationService smsIntegrationService;

    @Resource
    private UserInfoService userInfoService;

    @Override
    protected Message beforeLoginAuthentication(PhoneAppLoginParam loginParam) {
        if (!smsIntegrationService.verifyByType(SmsTemplateEnum.LOGIN, loginParam.getPhone(), loginParam.getSmsCode())) {
            return Message.build(false, "验证码错误");
        }

        return Message.build(true);
    }

    @Override
    protected Long checkExists(PhoneAppLoginParam loginParam) {
        Optional<Long> userPhoneExistOptional = userInfoService.userPhoneExist(loginParam.getPhone());

        return userPhoneExistOptional.orElse(null);
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.SMS;
    }

    @Override
    protected boolean saveIdentity(PhoneAppLoginParam loginParam, Long userId) {
        return true;
    }

    @Override
    protected void fillUserInfo(PhoneAppLoginParam loginParam, UserInfoEntity newUser) {
        newUser.setPhone(loginParam.getPhone());
        newUser.setUsername(loginParam.getPhone());
    }
}