package com.bxm.egg.user.manage.login.impl;

import com.bxm.component.jwt.builder.TokenBuildParam;
import com.bxm.component.jwt.util.JwtUtil;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.manage.login.UserManageLoginService;
import com.bxm.egg.user.mapper.manage.ManageChatAdminRelationMapper;
import com.bxm.egg.user.model.dto.manage.login.ManageLoginResultDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.manage.ManageChatAdminRelationEntity;
import com.bxm.egg.user.model.param.manage.login.UserManageLoginParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

import static com.bxm.egg.user.constant.UserConstant.USER_ID_KEY;

/**
 * @author lowi
 * @date 2022/2/16 15:08
 */
@AllArgsConstructor
@Service
@Slf4j
public class UserManageLoginServiceImpl implements UserManageLoginService {

    private final UserInfoService userInfoService;

    private final ManageChatAdminRelationMapper manageChatAdminRelationMapper;

    private final UserProperties userProperties;

    @Override
    public Message doLogin(UserManageLoginParam loginParam) {

        UserInfoEntity userInfoByUsername = userInfoService.getUserInfoByUsername(loginParam.getUsername());

        if (Objects.isNull(userInfoByUsername) || Objects.equals(userInfoByUsername.getDeleted(), 1)) {
            return Message.build(Boolean.FALSE).setMessage("账户不存在");
        }

        //判断用户是否设置密码
        if (Objects.isNull(userInfoByUsername.getPassword())) {
            return Message.build(false, "您的账户未设置密码");
        }

        //验证用户名密码是否正确
        String targetPassword = MD5Util.standardMd5(MD5Util.standardMd5(loginParam.getPassword()) + userInfoByUsername.getSalt());
        String realPassword = userInfoByUsername.getPassword();
        if (!Objects.equals(targetPassword, realPassword)) {
            return Message.build(false, "密码错误");
        }

        ManageChatAdminRelationEntity relationInfo = manageChatAdminRelationMapper.getRelationInfo(userInfoByUsername.getId());

        //判断对应关系
        if (Objects.isNull(relationInfo)) {
            return Message.build(false, "此账户无权限登录");
        }

        ManageLoginResultDTO manageLoginResultDTO = new ManageLoginResultDTO();
        manageLoginResultDTO.setAccessToken(getToken(relationInfo.getId()));
        manageLoginResultDTO.setAdminUserId(relationInfo.getId());
        manageLoginResultDTO.setHeadImg(userInfoByUsername.getHeadImg());
        manageLoginResultDTO.setNickName(userInfoByUsername.getNickname());
        Message resultMsg = Message.build(true);
        resultMsg.addParam("loginResultDTO", manageLoginResultDTO);
        return resultMsg;
    }

    private String getToken(Long userId) {
        return JwtUtil.generateToken(TokenBuildParam.create()
                .putClaim(USER_ID_KEY, userId.toString())
                .setIssueDate(new Date())
                .setSignatureKey(userProperties.getManageTokenSecret()));
    }
}
