package com.bxm.egg.user.medal.cache;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.facade.dto.UserGrantMedalDTO;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/3/8 12:06 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserMedalPopCacheManager {

    private RedisListAdapter redisListAdapter;

    private UserProperties userProperties;

    /**
     * 将要弹窗的勋章信息放到缓存中
     *
     * @param userId            用户id
     * @param userGrantMedalDTO 用户勋章弹窗信息
     */
    public void addUserMedalPopCache(Long userId, UserGrantMedalDTO userGrantMedalDTO) {
        KeyGenerator key = buildUserMedalPopKey(userId);

        userGrantMedalDTO.setV(UserGrantMedalDTO.CACHE_VERSION);

        redisListAdapter.leftPush(key, userGrantMedalDTO);
        redisListAdapter.expire(key, userProperties.getUserMedalPopExpiredSecond());
    }

    /**
     * 获取需要弹窗的勋章信息
     *
     * @param userId 用户id
     * @return 弹窗的勋章信息
     */
    public UserGrantMedalDTO getUserMedalPopCache(Long userId) {
        KeyGenerator key = buildUserMedalPopKey(userId);

        Long size = redisListAdapter.size(key);

        if (size == 0) {
            return null;
        }

        //处理错误的数据，所以用一下循环
        for (int i = 0; i < size; i++) {
            UserGrantMedalDTO userGrantMedalDTO = redisListAdapter.rightPop(key, UserGrantMedalDTO.class);

            if (userGrantMedalDTO == null) {
                return null;
            }
            if (Objects.nonNull(userGrantMedalDTO.getV()) && userGrantMedalDTO.getV() >= UserGrantMedalDTO.CACHE_VERSION) {
                return userGrantMedalDTO;
            }
        }

        return null;
    }

    private KeyGenerator buildUserMedalPopKey(Long userId) {
        return RedisConfig.USER_POP_MEDAL_DATA.copy().appendKey(userId);
    }

}