package com.bxm.egg.user.search.impl;

import com.bxm.egg.user.mapper.UserFollowMapper;
import com.bxm.egg.user.model.param.FollowListParam;
import com.bxm.egg.user.model.vo.FollowUserListVO;
import com.bxm.egg.user.search.UserSearchService;
import com.bxm.egg.user.model.vo.UserFollow;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gonzo
 * @date 2021-03-02 18:47
 **/
@Slf4j
@Service
@AllArgsConstructor
public class UserSearchServiceImpl implements UserSearchService {

    private final UserFollowMapper userFollowMapper;


    @Override
    public List<FollowUserListVO> followList(FollowListParam param) {
        List<UserFollow> userFollows = userFollowMapper.searchFollow(param);
        return userFollows.stream()
                .map(this::convert)
                .collect(Collectors.toList());
    }

    private FollowUserListVO convert(UserFollow follow) {
        FollowUserListVO listVO = new FollowUserListVO();
        listVO.setUserId(follow.getUserId());
        listVO.setNickname(follow.getNickname());
        listVO.setHeadImg(follow.getHeadImg());

        return listVO;
    }
}