package com.bxm.egg.user.timer;

import com.bxm.egg.user.medal.UserMedalCounterService;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

import static com.bxm.egg.user.constant.RedisConfig.MEDAL_REFRESH_MSG_LIST;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/20 9:54 下午
 */
@Component
@Slf4j
public class MedalHandleTask extends AbstractCronXxlJob {

    @Resource
    private UserMedalCounterService userMedalCounterService;

    @Resource
    private RedisSetAdapter redisSetAdapter;

    @Resource
    private UserProperties userProperties;

    @Resource
    @Qualifier("globalAsyncTaskExecutor")
    private AsyncTaskExecutor taskExecutor;

    private static final int PARALLEL_THREAD_NUM = 5;

    @Override
    public String cron() {
        return "0 0/2 * * * ?";
    }


    @Override
    protected void executeLogic() {
        if (log.isDebugEnabled()) {
            log.debug("处理勋章数据消息定时任务==========");
        }

        for (int i = 0; i < PARALLEL_THREAD_NUM; i++) {
            taskExecutor.execute(() -> {
                while (true) {
                    List<UserMedalCounterDTO> userMedalMsgList = redisSetAdapter.pop(MEDAL_REFRESH_MSG_LIST,
                            userProperties.getHandleMedalMsgSpeech(),
                            UserMedalCounterDTO.class);

                    log.info("获取到勋章数据：{}", userMedalMsgList.size());

                    for (UserMedalCounterDTO userMedalCounterDTO : userMedalMsgList) {
                        userMedalCounterService.handleMedalCounterData(userMedalCounterDTO);
                    }

                    if (userMedalMsgList.size() < userProperties.getHandleMedalMsgSpeech()) {
                        break;
                    }
                }
            });
        }
    }

    @Override
    public String jobDesc() {
        return "处理勋章数据消息";
    }

    @Override
    public String author() {
        return "我wzy";
    }
}