package com.bxm.egg.user.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author lowi
 * @date 2021/11/5 19:17
 */
@Slf4j
public class FileMd5Util {

    public static String getMd5(byte[] buffer) {
        String md5Result = null;
        try {
            InputStream is1 = new ByteArrayInputStream(buffer);
            while (is1.read(buffer) > 0) {
                md5Result = DigestUtils.md5Hex(buffer);
            }
        } catch (IOException e) {
            log.error("获取文件md5出错");
        }
        return md5Result;
    }
}
