package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.param.HelpInfoQueryParam;
import com.bxm.localnews.activity.service.HelpInfoService;
import com.bxm.localnews.activity.vo.HelpCertInfo;
import com.bxm.localnews.activity.vo.HelpIndexPageInfo;
import com.bxm.localnews.activity.vo.HelpRankInfo;
import com.bxm.localnews.activity.vo.HelpWindowInfo;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(tags = "2-13 公益活动助力相关", description = "公益活动助力相关")
@RestController
@RequestMapping("api/public/helpInfo")
public class HelpInfoController extends BaseController {

    @Resource
    private HelpInfoService helpInfoService;

    @ApiOperation(value = "2-13-1 判断是否活动区域")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    @GetMapping("isActiveArea")
    public Json<Boolean> isActiveArea(@RequestParam(value = "areaCode") String areaCode) {
        return ResultUtil.genSuccessResult(helpInfoService.isActiveArea(areaCode));
    }

    @ApiOperation(value = "2-13-2 获取助力首页信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "size", value = "获取轮播信息条数", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "pageType", value = "页面类型：1主页 2助力成功页", required = true)
    })
    @GetMapping("getIndexPageInfo")
    public Json<HelpIndexPageInfo> getIndexPageInfo(@RequestParam(value = "size") Integer size,
                                                    @RequestParam(value = "userId") Long userId,
                                                    @RequestParam(value = "pageType") Integer pageType) {
        return ResultUtil.genSuccessResult(helpInfoService.getIndexPageInfo(size, userId, pageType));
    }

    @ApiOperation(value = "2-13-3 获取排行榜")
    @GetMapping("getRankingList")
    public Json<PageWarper<HelpRankInfo>> getRankingList(HelpInfoQueryParam param) {
        return ResultUtil.genSuccessResult(helpInfoService.getRankingList(param));
    }

    @ApiOperation(value = "2-13-4 获取用户排名信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @GetMapping("getUserRank")
    public Json<HelpRankInfo> getUserRank(@RequestParam(value = "userId") Long userId) {
        return ResultUtil.genSuccessResult(helpInfoService.getUserRank(userId));
    }

    @ApiOperation(value = "2-13-5 助力")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
            @ApiImplicitParam(name = "areaName", value = "地区名", required = false),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "type", value = "助力类型：1个人助力 2团队助力 3邀请助力", required = true),
            @ApiImplicitParam(name = "teamName", value = "团队名", required = false),
            @ApiImplicitParam(name = "inviteUserId", value = "邀请助力用户id", required = false)
    })
    @PostMapping("help")
    public Json<Message> help(
            @RequestParam(value = "areaCode") String areaCode,
            @RequestParam(value = "areaName", required = false) String areaName,
            @RequestParam(value = "userId") Long userId,
            @RequestParam(value = "type") Byte type,
            @RequestParam(value = "teamName", required = false) String teamName,
            @RequestParam(value = "inviteUserId", required = false) Long inviteUserId) {
        return ResultUtil.genSuccessResult(helpInfoService.help(areaCode, areaName, userId, type, teamName, inviteUserId));
    }

    @ApiOperation(value = "2-13-6 团队头像编辑")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "teamImg", value = "团队头像", required = true)
    })
    @PostMapping("updateTeamImg")
    public Json<Message> updateTeamImg(@RequestParam(value = "userId") Long userId,
                                       @RequestParam(value = "teamImg") String teamImg) {
        return ResultUtil.genSuccessResult(helpInfoService.updateTeamImg(userId, teamImg));
    }

    @ApiOperation(value = "2-13-7 获取用户证书信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @GetMapping("getUserCert")
    public Json<HelpCertInfo> getUserCert(@RequestParam(value = "userId") Long userId) {
        return ResultUtil.genSuccessResult(helpInfoService.getUserCert(userId));
    }

    @ApiOperation(value = "2-13-8 分享生成帖子")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
            @ApiImplicitParam(name = "base64Str", value = "base64编码", required = true)
    })
    @PostMapping("shareCreatePost")
    public Json<Message> shareCreatePost(@RequestParam(value = "userId") Long userId,
                                         @RequestParam(value = "areaCode") String areaCode,
                                         @RequestParam(value = "base64Str") String base64Str) {
        return ResultUtil.genSuccessResult(helpInfoService.shareCreatePost(userId, areaCode, base64Str));
    }

    @ApiOperation(value = "2-13-9 获取弹窗信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @GetMapping("getHelpWindowInfo")
    public Json<HelpWindowInfo> getHelpWindowInfo(@RequestParam(value = "areaCode") String areaCode,
                                                  @RequestParam(value = "userId") Long userId) {
        return ResultUtil.genSuccessResult(helpInfoService.getHelpWindowInfo(areaCode, userId));
    }

    @ApiOperation(value = "2-13-10 创建助力用户邀请关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "inviteUserId", value = "邀请用户id", required = true)
    })
    @PostMapping("createHelpUserInvite")
    public Json<Message> createHelpUserInvite(@RequestParam(value = "userId") Long userId,
                                              @RequestParam(value = "inviteUserId") Long inviteUserId) {
        return ResultUtil.genSuccessResult(helpInfoService.createHelpUserInvite(userId, inviteUserId));
    }

}

