package com.bxm.localnews.activity.facade.controller;

import java.math.BigDecimal;

import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.UserAccountIntegrationService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "2-90 [内部接口]活动任务相关接口")
@RestController
@RequestMapping("facade/activity/mission")
@Slf4j
public class MissionFacadeController {

    private final MissionService missionService;

    private final UserAccountIntegrationService userAccountIntegrationService;

    @Autowired
    public MissionFacadeController(MissionService missionService,
                                   UserAccountIntegrationService userAccountIntegrationService) {
        this.missionService = missionService;
        this.userAccountIntegrationService = userAccountIntegrationService;
    }

    @ApiOperation("2-90-1 完成指定的任务")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "完成任务的用户ID"),
            @ApiImplicitParam(name = "taskName", value = "任务编码，取值详见com.bxm.localnews.common.constant.TaskEnum"),
            @ApiImplicitParam(name = "relationId", value = "完成任务关联的ID")
    })
    @PostMapping("comple")
    public ResponseEntity<NewsMissionRewardDto> compleTask(@RequestParam Long userId,
                                                           @RequestParam String taskName,
                                                           @RequestParam(required = false) String relationId,
                                                           @RequestParam(required = false) String content

    ) {
        TaskEnum task = null;

        try {
            task = TaskEnum.valueOf(taskName);
        } catch (Exception e) {
            log.error("任务类型[{}]不存在", taskName);
        }

        if (null == task) {
            return ResponseEntity.badRequest().body(new NewsMissionRewardDto());
        }

        NewsMissionRewardDto reward = missionService.completeTask(userId, TaskEnum.valueOf(taskName), relationId,content);

        return ResponseEntity.ok(reward);
    }
}
