package com.bxm.localnews.activity.facade.controller;

import com.bxm.localnews.activity.dto.SignWarper;
import com.bxm.localnews.activity.service.SignFacadeService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/3/7 17:43
 * @desc
 */
@Api(tags = "2-92 [内部接口]签到相关接口")
@RestController
@RequestMapping("facade/activity/sign")
@Slf4j
public class SignFacadeController {

    @Autowired
    private SignFacadeService signFacadeService;

    @ApiOperation(value = "2-92-1 获取用户签到信息", notes = "获取用户签到信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "platform", value = "渠道", required = true)
    })
    @GetMapping("/list")
    public ResponseEntity<SignWarper> saveVipViewRecord(@RequestParam("userId") Long userId,
                                                        @RequestParam("platform") int platform) {
        return ResponseEntity.ok(signFacadeService.listSignRecord(userId, platform));
    }

    @ApiOperation(value = "2-92-2 每天凌晨更新签到每个地区的排行榜", notes = "每天凌晨更新签到每个地区的排行榜，并判断是否开启新的地区")
    @GetMapping("/dailySync")
    public ResponseEntity syncSignDailySync() {
        signFacadeService.syncSignRanking();
        return ResponseEntity.ok().build();
    }

    @ApiOperation(value = "2-92-2 每天19:00向用户推送签到信息提醒用户签到", notes = "当天签到后，第二天19点，若用户还没签到，则发送系统通知push：朋友，你今天还没有签到哦，快来>")
    @GetMapping("/notification")
    public ResponseEntity noticeUserSign() {
        signFacadeService.noticeUserSign();
        return ResponseEntity.ok().build();
    }

}
