/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.activity.dto.CustomerServiceDTO;
import com.bxm.localnews.activity.dto.UserSuccessFriendDTO;
import com.bxm.localnews.activity.dto.UserVipInfoDTO;
import com.bxm.localnews.activity.dto.WechatUserInfoDTO;
import com.bxm.localnews.activity.dto.WechatVipInfoDTO;
import com.bxm.localnews.activity.param.RecordWechatParam;
import com.bxm.localnews.activity.service.VipService;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-07 VIP\u76f8\u5173\u63a5\u53e3"}, description="\u5305\u62ecVIP\u7684\u76f8\u5173\u63a5\u53e3\u64cd\u4f5c")
@RestController
@RequestMapping(value={"/api/vip"})
public class VipController {
    private static final Logger logger = LoggerFactory.getLogger(VipController.class);
    private VipService vipService;
    private UserIntegrationService userIntegrationService;

    @Autowired
    public VipController(VipService vipService, UserIntegrationService userIntegrationService) {
        this.vipService = vipService;
        this.userIntegrationService = userIntegrationService;
    }

    @ApiOperation(value="2-07-1 \u83b7\u53d6\u6210\u529f\u9080\u8bf7\u597d\u53cb\u7684\u5217\u8868", notes="\u5728\u9996\u9875\u5f15\u5bfc\u6d41\u7a0b\u548c\u7528\u6237\u6fc0\u6d3bvip\u8fdb\u5ea6\u65f6\u8c03\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long", required=true)})
    @GetMapping(value={"/invite/success"})
    public Json<UserSuccessFriendDTO> inviteFriendSuccess(Long userId) {
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
        logger.info("vip\u9080\u8bf7\u597d\u53cb\u65f6\u7528\u6237\u4fe1\u606f:{}", JSON.toJSON((Object)userInfoDTO));
        if (StringUtils.isEmpty((CharSequence)userInfoDTO.getWeixin())) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u60a8\u672a\u7ed1\u5b9a\u5fae\u4fe1,\u8bf7\u9000\u51fa\u8d26\u53f7\u540e\u91cd\u65b0\u767b\u5f55");
        }
        return ResultUtil.genSuccessResult((Object)this.vipService.getSuccessFriend(userId));
    }

    @ApiOperation(value="2-07-2 \u67e5\u770b\u7528\u6237\u5206\u4eab\u7684vip\u9875\u9762\u7684\u7528\u6237\u5fae\u4fe1\u597d\u53cb\u5217\u8868", notes="\u7528\u4e8e\u67e5\u770b\u7528\u6237\u5fae\u4fe1\u597d\u53cb\u67e5\u770b\u7528\u6237\u5206\u4eabVIP\u9875\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long", required=true)})
    @GetMapping(value={"/invite/record"})
    public Json<List<WechatUserInfoDTO>> inviteFriendRecord(Long userId) {
        return ResultUtil.genSuccessResult((Object)this.vipService.getInviteFriendRecord(userId));
    }

    @ApiOperation(value="2-07-3 \u8bb0\u5f55\u7528\u6237\u67e5\u770b\u8bb0\u5f55", notes="\u8bb0\u5f55\u7528\u6237\u5fae\u4fe1\u597d\u53cb\u67e5\u770b\u7528\u6237\u5206\u4eabvip\u7684\u9875\u9762\u4fe1\u606f")
    @PostMapping(value={"/record"})
    public Json recordUser(RecordWechatParam recordWechatParam) {
        this.vipService.addViewRecord(recordWechatParam);
        return ResultUtil.genSuccessMsg((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @ApiOperation(value="2-07-4 \u83b7\u53d6\u5ba2\u670d\u4fe1\u606f", notes="\u8fd4\u56de\u5ba2\u670d\u4e8c\u7ef4\u7801\u5730\u5740\u548c\u5fae\u4fe1\u53f7")
    @GetMapping(value={"/customer/service"})
    public Json<CustomerServiceDTO> customerService() {
        return ResultUtil.genSuccessResult((Object)this.vipService.getCustomerService());
    }

    @ApiOperation(value="2-07-5 \u9884\u9886\u53d6vip", notes="\u8bb0\u5f55\u7528\u6237\u9886\u53d6vip\u5361\u4f46\u662f\u4e0d\u6fc0\u6d3b\uff0c\u9886\u53d6vip\u5361\u65f6\u8c03\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", dataType="String", required=true), @ApiImplicitParam(name="unionId", value="\u7528\u6237\u5fae\u4fe1ID", dataType="String", required=true), @ApiImplicitParam(name="wechatName", value="\u7528\u6237\u5fae\u4fe1\u6635\u79f0", dataType="String", required=true), @ApiImplicitParam(name="wechatImg", value="\u7528\u6237\u5fae\u4fe1\u5934\u50cf", dataType="String", required=true)})
    @PostMapping(value={"/receive"})
    public Json<WechatVipInfoDTO> advanceReceiveVip(String unionId, String areaCode, String wechatName, String wechatImg) {
        return ResultUtil.genSuccessResult((Object)this.vipService.addWechatUserVip(areaCode, unionId, wechatName, wechatImg));
    }

    @ApiOperation(value="2-07-6 \u66f4\u65b0\u7528\u6237VIP\u5f15\u5bfc\u6807\u8bb0", notes="\u5f15\u5bfc\u7528\u6237\u67e5\u770bvip\u83b7\u53d6\u6d41\u7a0b\u540e\u66f4\u65b0\u7528\u6237\u4e0d\u518d\u663e\u793a\u5f15\u5bfc\u9875\u65f6\u8c03\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long", required=true)})
    @PostMapping(value={"/guide"})
    public Json updateGuide(Long userId) {
        return ResultUtil.genSuccessResult((Object)this.vipService.modifyUserGuid(userId));
    }

    @ApiOperation(value="2-07-7 \u901a\u8fc7\u7528\u6237id\u67e5\u770bvip\u4fe1\u606f", notes="\u7528\u6237\u8fdb\u5165app\u5185\u83b7\u53d6\u5bf9\u5e94vip\u4fe1\u606f\u65f6\u8c03\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", dataType="String", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long", required=true)})
    @GetMapping(value={"/view/userId"})
    public Json<UserVipInfoDTO> viewUserVip(String areaCode, Long userId) {
        return ResultUtil.genSuccessResult((Object)this.vipService.modifyAndGetUserVip(userId, areaCode));
    }

    @ApiOperation(value="2-07-8 \u901a\u8fc7\u5fae\u4fe1uid\u67e5\u770bVIP\u4fe1\u606f", notes="\u5fae\u4fe1\u6388\u6743\u767b\u9646\u65f6\u83b7\u53d6\u7528\u6237vip\u4fe1\u606f\uff0ch5\u5fae\u4fe1\u7aef\u8c03\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", dataType="String", required=true), @ApiImplicitParam(name="unionId", value="\u7528\u6237\u5fae\u4fe1ID", dataType="String", required=true)})
    @GetMapping(value={"/view/unionId"})
    public Json<WechatVipInfoDTO> viewUserVip(String unionId, String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.vipService.getWechatVip(unionId, areaCode));
    }

    @ApiOperation(value="2-07-9 \u67e5\u770bvip\u5df2\u6fc0\u6d3b\u7684\u8f6e\u64ad\u4fe1\u606f", notes="\u53ea\u8fd4\u56de\u7528\u6237\u6635\u79f0\u5217\u8868\uff0c\u7528\u4e8e\u67e5\u770b\u7528\u6237vip\u5206\u4eab\u9875\u9762\u65f6\u8c03\u7528")
    @GetMapping(value={"/view/rank"})
    public Json<List<WechatUserInfoDTO>> viewVipSuccessRank() {
        return ResultUtil.genSuccessResult((Object)this.vipService.getVipRank());
    }

    @ApiOperation(value="2-07-10 \u66f4\u65b0\u7528\u6237\u4e0d\u518d\u63d0\u793a\u663e\u793a\u6d6e\u5c42", notes="\u7528\u4e8eapp\u9996\u9875\u662f\u5426\u663e\u793a\u7528\u6237\u6fc0\u6d3bvip\u5361\u663e\u793a\u7684\u6d6e\u5c42")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long", required=true)})
    @PostMapping(value={"/view/layer"})
    public Json<Message> viewUserLayer(Long userId) {
        return ResultUtil.genSuccessResult((Object)this.vipService.modifyUserShowLayer(userId));
    }

    @ApiOperation(value="2-07-11 \u83b7\u53d6\u7528\u6237\u9080\u8bf7\u6210\u529f\u7684\u6240\u6709\u597d\u53cb\u5217\u8868", notes="\u7528\u4e8e\u663e\u793a\u7528\u6237\u9080\u8bf7\u597d\u53cb\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long", required=true)})
    @GetMapping(value={"/invite/success/all"})
    public Json<List<WechatUserInfoDTO>> getWechatUserList(Long userId) {
        return ResultUtil.genSuccessResult((Object)this.vipService.getAllSuccessWechatUserList(userId));
    }
}

