/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.facade.controller;

import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-90 [\u5185\u90e8\u63a5\u53e3]\u6d3b\u52a8\u4efb\u52a1\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"facade/activity/mission"})
public class MissionFacadeController {
    private static final Logger log = LoggerFactory.getLogger(MissionFacadeController.class);
    private final MissionService missionService;
    private final UserAccountIntegrationService userAccountIntegrationService;

    @Autowired
    public MissionFacadeController(MissionService missionService, UserAccountIntegrationService userAccountIntegrationService) {
        this.missionService = missionService;
        this.userAccountIntegrationService = userAccountIntegrationService;
    }

    @ApiOperation(value="2-90-1 \u5b8c\u6210\u6307\u5b9a\u7684\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u5b8c\u6210\u4efb\u52a1\u7684\u7528\u6237ID"), @ApiImplicitParam(name="taskName", value="\u4efb\u52a1\u7f16\u7801\uff0c\u53d6\u503c\u8be6\u89c1com.bxm.localnews.common.constant.TaskEnum"), @ApiImplicitParam(name="relationId", value="\u5b8c\u6210\u4efb\u52a1\u5173\u8054\u7684ID")})
    @PostMapping(value={"comple"})
    public ResponseEntity<NewsMissionRewardDto> compleTask(@RequestParam Long userId, @RequestParam String taskName, @RequestParam(required=false) String relationId, @RequestParam(required=false) String content) {
        TaskEnum task = null;
        try {
            task = TaskEnum.valueOf((String)taskName);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u7c7b\u578b[{}]\u4e0d\u5b58\u5728", (Object)taskName);
        }
        if (null == task) {
            return ResponseEntity.badRequest().body((Object)new NewsMissionRewardDto());
        }
        NewsMissionRewardDto reward = this.missionService.completeTask(userId, TaskEnum.valueOf((String)taskName), relationId, content);
        return ResponseEntity.ok((Object)reward);
    }
}

