/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.dto.CalendarSignDTO;
import com.bxm.localnews.activity.dto.SignDTO;
import com.bxm.localnews.activity.dto.SignLeaderBoard;
import com.bxm.localnews.activity.service.sign.DailySignService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-01 \u6bcf\u65e5\u7b7e\u5230\u63a5\u53e3"}, description="\u7b7e\u5230\u5fc5\u987b\u767b\u5f55\u540e\u624d\u53ef\u4ee5\u8bbf\u95ee")
@RestController
@RequestMapping(value={"api/sign/public"})
public class DailySignController {
    @Resource
    private DailySignService dailySignService;

    @ApiOperation(value="2-01-1 \u83b7\u53d6\u7528\u6237\u7684\u7b7e\u5230\u8bb0\u5f55", notes="\u7b7e\u5230\u9875\u9762\u76f8\u5173\u4fe1\u606f\uff1a\u9664\u4e86\u65e5\u5386\u7b7e\u5230\u5217\u8868\u4fe1\u606f\uff0c\u5176\u4f59\u76f8\u5173\u4fe1\u606f\u90fd\u5728\u6b64\u63a5\u53e3\u8fd4\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u53f7", required=true)})
    @GetMapping(value={"signRecord"})
    public Json<SignDTO> signRecord(@RequestParam(value="userId") Long userId, @RequestParam(value="areaCode") String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.dailySignService.signRecord(userId, areaCode));
    }

    @ApiOperation(value="2-01-2 \u83b7\u53d6\u7528\u6237\u5bf9\u5e94\u7b7e\u5230\u7684\u6708\u5386", notes="\u7b7e\u5230\u65e5\u5386\u53ca\u5176\u76f8\u5173\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @GetMapping(value={"listSignRecord"})
    public Json<List<CalendarSignDTO>> listSignRecord(@RequestParam(value="userId") Long userId) {
        return ResultUtil.genSuccessResult((Object)this.dailySignService.listSignRecord(userId));
    }

    @ApiOperation(value="2-01-3 \u7528\u6237\u7b7e\u5230", notes="\u7528\u6237\u8fdb\u884c\u7b7e\u5230---\u53ea\u9488\u5bf9\u5f53\u5929\u7b7e\u5230")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u53f7", required=true)})
    @PostMapping
    public Json<Boolean> userSign(@RequestParam(value="userId") Long userId, @RequestParam(value="areaCode") String areaCode) {
        Message message = this.dailySignService.executeUserSign(userId, areaCode);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult((String)message.getLastMessage());
        }
        return ResultUtil.genSuccessResult((Object)message.isSuccess());
    }

    @ApiOperation(value="2-01-4 \u7528\u6237\u8865\u7b7e", notes="\u7528\u6237\u8fdb\u884c\u8865\u7b7e---\u53ea\u9488\u5bf9\u6628\u65e5\u7b7e\u5230")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u53f7", required=true)})
    @PostMapping(value={"/fill"})
    public Json<Boolean> userFillSign(@RequestParam(value="userId") Long userId, @RequestParam(value="areaCode") String areaCode) {
        Message message = this.dailySignService.executeUserFillSign(userId, areaCode);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult((String)message.getLastMessage());
        }
        return ResultUtil.genSuccessResult((Object)message.isSuccess());
    }

    @ApiOperation(value="2-01-5 \u83b7\u53d6\u67d0\u4e2a\u5730\u533a\u7684\u7b7e\u5230\u6392\u884c\u699c\u4ee5\u53ca\u81ea\u5df1\u7684\u7b7e\u5230\u4fe1\u606f", notes="1)\u7b7e\u5230\u6392\u884c\u699c\u6570\u636e\u533a\u5206\u5730\u533a\uff0c\u6839\u636e\u6700\u8fd1\u4e00\u6b21\u7b7e\u5230\u65f6\u6240\u9009\u7684\u5730\u533a\u51b3\u5b9a\uff0c\u66f4\u6362\u5730\u533a\u7b7e\u5230\u4e0d\u5f71\u54cd\u8fde\u7eed\u7b7e\u5230\u5929\u6570\n2)\u6309\u7167\u8fde\u7eed\u7b7e\u5230\u5929\u6570\u8fdb\u884c\u964d\u5e8f\u6392\u540d\uff0c\u53d6\u524d20\u540d\uff0c\u82e5\u5929\u6570\u76f8\u540c\uff0c\u5219id\u53f7\u5c0f\u7684\u6392\u540d\u9760\u524d\n3)\u524d3\u540d\u82e5\u65e0\u6570\u636e\uff0c\u5219\u663e\u793a\u5982\u53f3\u56fe\u6240\u793a\uff0c\u865a\u4f4d\u4ee5\u5f85\n4)\u5de6\u4e0a\u89d2\u201c\u5e7f\u5fb7\u201d\u4ec5\u4f9b\u663e\u793a\u5f53\u524d\u6392\u884c\u699c\u7684\u6240\u5c5e\u5730\u533a\uff0c\u4e0d\u53ef\u70b9\u51fb\n5)\u9875\u9762\u5e95\u90e8\u7f6e\u5e95\u60ac\u6d6e\u663e\u793a\u5f53\u524d\u8bbf\u95ee\u7528\u6237\u7684\u4fe1\u606f\uff1a\u6392\u540d\u3001\u5934\u50cf\u3001\u6635\u79f0\u3001\u8fde\u7eed\u7b7e\u5230\u5929\u6570\u3002\n>\u82e5\u5f53\u524d\u7528\u6237\u5df2\u5728\u5f53\u524d\u5730\u533a\u7b7e\u5230\u4f46\u672a\u8fdb\u5165\u524d20\u540d\uff0c\u5219\u6392\u540d\u663e\u793a\u4e3a\uff1a\u6682\u672a\u4e0a\u699c\n>\u82e5\u5f53\u524d\u7528\u6237\u672a\u5728\u5f53\u524d\u5730\u533a\u7b7e\u5230\uff0c\u5219\u8fde\u7eed\u7b7e\u5230\u5929\u6570\u663e\u793a\u4e3a\uff1a\u8fd8\u672a\u5728\u5e7f\u5fb7\u7b7e\u5230\u3002\u5730\u533a\u540d\u52a8\u6001\u663e\u793a\n6)\u6392\u884c\u699c\u6570\u636e\u9700\u5c3d\u91cf\u5b9e\u65f6\u66f4\u65b0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u53f7", required=true)})
    @GetMapping(value={"/ranking"})
    public Json<SignLeaderBoard> listSignLeaderBoard(@RequestParam(value="userId") Long userId, @RequestParam(value="areaCode") String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.dailySignService.getSignLeaderBoard(userId, areaCode));
    }
}

