/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.common.config.ActivityDrawProperties;
import com.bxm.localnews.activity.param.CashDetailParam;
import com.bxm.localnews.activity.service.LotteryDrawService;
import com.bxm.localnews.activity.vo.WechatUserInfoVo;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-11 \u5c0f\u7a0b\u5e8f\u62bd\u5956"}, description="\u5c0f\u7a0b\u5e8f\u62bd\u5956\u76f8\u5173\u64cd\u4f5c")
@RestController
@RefreshScope
@RequestMapping(value={"api/public/lotteryDraw"})
public class LotteryDrawController {
    @Resource
    private LotteryDrawService lotteryDrawService;
    @Resource
    private ActivityDrawProperties activityDrawProperties;

    @ApiOperation(value="2-11-1 \u83b7\u53d6\u62bd\u5956\u7528\u6237\u4fe1\u606f", notes="\u5224\u65ad\u662f\u5426\u6d3b\u52a8\u533a\u57df\uff0c\u8fd4\u56de\u7528\u6237\u94b1\u5305\u4f59\u989d\uff0c\u5269\u4f59\u62bd\u5956\u6b21\u6570\u4ee5\u53ca\u80fd\u5426\u589e\u52a0\u62bd\u5956\u6b21\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="city", value="\u5e02\u7ea7\u4fe1\u606f", required=false), @ApiImplicitParam(name="district", value="\u533a\u7ea7\u4fe1\u606f", required=false)})
    @GetMapping(value={"getUserInfo"})
    public Json<WechatUserInfoVo> getUserInfo(@RequestParam(name="userId") Long userId, @RequestParam(name="city", required=false) String city, @RequestParam(name="district", required=false) String district) {
        return ResultUtil.genSuccessResult((Object)this.lotteryDrawService.getUserInfo(userId, city, district));
    }

    @ApiOperation(value="2-11-2 \u83b7\u53d6\u5956\u9879")
    @GetMapping(value={"getPrizeList"})
    public Json<List<BigDecimal>> getPrizeList() {
        return ResultUtil.genSuccessResult((Object)this.lotteryDrawService.getPrizeList());
    }

    @ApiOperation(value="2-11-3 \u83b7\u53d6\u4e2d\u5956\u7528\u6237\u5217\u8868")
    @GetMapping(value={"getWinUserList"})
    public Json<List<WechatUserInfoVo>> getWinUserList() {
        return ResultUtil.genSuccessResult((Object)this.lotteryDrawService.getWinUserList());
    }

    @ApiOperation(value="2-11-4 \u62bd\u5956", notes="\u8fd4\u56de\u4e2d\u5956\u91d1\u989d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=false), @ApiImplicitParam(name="platform", value="\u5e73\u53f0\u7c7b\u578b: 3:h5 4:\u5c0f\u7a0b\u5e8f", required=false)})
    @PostMapping(value={"lotteryDraw"})
    public Json<String> lotteryDraw(@RequestParam(name="userId") Long userId, BasicParam basicParam, @RequestParam(name="areaCode", required=false) String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.lotteryDrawService.lotteryDraw(userId, Integer.valueOf(basicParam.getPlatform()), areaCode));
    }

    @ApiOperation(value="2-11-5 \u5206\u4eab", notes="\u589e\u52a0\u62bd\u5956\u6b21\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    @PostMapping(value={"share"})
    public Json<Boolean> share(@RequestParam(name="userId") Long userId) {
        return ResultUtil.genSuccessResult((Object)this.lotteryDrawService.share(userId));
    }

    @ApiOperation(value="2-11-6 \u83b7\u53d6\u660e\u7ec6")
    @GetMapping(value={"getDetailPage"})
    public Json<PageWarper<WechatUserInfoVo>> getDetailPage(@Valid CashDetailParam param) {
        return ResultUtil.genSuccessResult((Object)this.lotteryDrawService.getDetailPage(param));
    }

    @ApiOperation(value="2-11-7 \u5206\u4eab\u5f00\u5173\u63a7\u5236", notes="\u5206\u4eab\u65f6\uff1a0 \u8868\u793a\u5c0f\u7a0b\u5e8f 1\u8868\u793aH5")
    @GetMapping(value={"/switch"})
    public Json<Byte> getShareSwitch() {
        return ResultUtil.genSuccessResult((Object)this.activityDrawProperties.getSwitchType());
    }

    @ApiOperation(value="2-11-8 \u662f\u5426\u6d3b\u52a8\u533a\u57df", notes="\u5224\u65ad\u662f\u5426\u6d3b\u52a8\u533a\u57df")
    @ApiImplicitParams(value={@ApiImplicitParam(name="city", value="\u5e02\u7ea7\u4fe1\u606f", required=false), @ApiImplicitParam(name="district", value="\u533a\u7ea7\u4fe1\u606f", required=false)})
    @GetMapping(value={"isActiveArea"})
    public Json<Boolean> isActiveArea(@RequestParam(name="city", required=false) String city, @RequestParam(name="district", required=false) String district) {
        return ResultUtil.genSuccessResult((Object)this.lotteryDrawService.isActiveArea(city, district));
    }
}

