/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.common.utils;

import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import java.io.File;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordUtils {
    private static final Logger log = LoggerFactory.getLogger(RecordUtils.class);
    static String[] units = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341\u4e07", "\u767e\u4e07", "\u5343\u4e07", "\u4ebf", "\u5341\u4ebf", "\u767e\u4ebf", "\u5343\u4ebf", "\u4e07\u4ebf"};
    static char[] numArray = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static String[] number_zh = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};

    private RecordUtils() {
    }

    public static int getDuration(File recordFile) {
        Encoder encoder = new Encoder();
        long ls = 0L;
        try {
            MultimediaInfo m = encoder.getInfo(recordFile);
            ls = m.getDuration() / 1000L;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f55\u97f3\u65f6\u957f\u9519\u8bef\uff0c\u6587\u4ef6\u4e3a\uff1a" + recordFile, (Throwable)e);
        }
        return (int)ls;
    }

    public static String shuzizhuanzhongwen(Long number) {
        StringBuffer sb = new StringBuffer();
        String str = number.toString();
        Stack<String> strStack = new Stack<String>();
        for (int i = 0; i < str.length(); ++i) {
            strStack.push(number_zh[(int)(number % 10L)]);
            number = number / 10L;
        }
        while (!strStack.isEmpty()) {
            sb.append((String)strStack.pop());
        }
        return sb.toString();
    }

    public static String formatInteger(long num) {
        char[] val = String.valueOf(num).toCharArray();
        int len = val.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            String m = val[i] + "";
            int n = Integer.valueOf(m);
            boolean isZero = n == 0;
            String unit = units[len - 1 - i];
            if (isZero && '0' != val[i - 1]) {
                sb.append(numArray[n]);
                continue;
            }
            sb.append(numArray[n]);
            sb.append(unit);
        }
        return sb.toString();
    }

    public static String formatDecimal(long decimal) {
        if (decimal > 99999L) {
            return RecordUtils.shuzizhuanzhongwen(decimal);
        }
        return RecordUtils.tansform(decimal);
    }

    private static String tansform(long number) {
        String a = String.valueOf(number);
        int length = a.length();
        String digit = "";
        String num = "";
        String zh = "";
        boolean zerointerval = true;
        for (int i = 0; i < a.length(); ++i) {
            if (length == 2) {
                digit = "\u5341";
            } else if (length == 3) {
                digit = "\u767e";
            } else if (length == 4) {
                digit = "\u5343";
            } else if (length == 5) {
                digit = "\u4e07";
            } else if (length == 6) {
                digit = "\u5341\u4e07";
            } else if (length == 7) {
                digit = "\u767e\u4e07";
            } else if (length == 8) {
                digit = "\u5343\u4e07";
            } else if (length == 9) {
                digit = "\u4ebf";
            } else if (length == 10) {
                digit = "\u5341\u4ebf";
            } else if (length == 11) {
                digit = "\u767e\u4ebf";
            } else if (length == 12) {
                digit = "\u5343\u4ebf";
            } else if (length == 13) {
                digit = "\u4e07\u4ebf";
            } else if (length == 1) {
                digit = "";
            }
            String s = (String)a.subSequence(i, i + 1);
            if ("1".equals(s)) {
                num = "\u4e00";
            } else if ("2".equals(s)) {
                num = "\u4e8c";
            } else if ("3".equals(s)) {
                num = "\u4e09";
            } else if ("4".equals(s)) {
                num = "\u56db";
            } else if ("5".equals(s)) {
                num = "\u4e94";
            } else if ("6".equals(s)) {
                num = "\u516d";
            } else if ("7".equals(s)) {
                num = "\u4e03";
            } else if ("8".equals(s)) {
                num = "\u516b";
            } else if ("9".equals(s)) {
                num = "\u4e5d";
            } else if ("0".equals(s)) {
                if (zerointerval) {
                    num = "\u96f6";
                    digit = "";
                    zerointerval = false;
                } else {
                    num = "";
                    digit = "";
                }
            }
            --length;
            if (!"".equals(digit)) {
                zerointerval = true;
            }
            if (digit.contains("\u4ebf")) {
                zh = zh.replace("\u4ebf", "");
            }
            if (digit.contains("\u4e07")) {
                zh = zh.replace("\u4e07\u4ebf", "wanyi");
                zh = zh.replace("\u4e07", "");
                zh = zh.replace("wanyi", "\u4e07\u4ebf");
            }
            zh = zh + num + digit;
        }
        zh = RecordUtils.deletezero(zh);
        return zh;
    }

    public static String deletezero(String zh) {
        String lasts = (String)zh.subSequence(zh.length() - 1, zh.length());
        if ("\u96f6".equals(lasts)) {
            zh = zh.substring(0, zh.length() - 1);
        }
        return zh;
    }
}

