/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.common.utils;

import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Decoder;

@Component
public class UploadBase64Img {
    private static final String BASE64_JPEG = "data:image/jpeg;base64,";
    private static final String BASE64_PNG = "data:image/png;base64,";
    @Resource
    private AliyunOSSService aliyunOSSService;

    public String uploadBase64Img(String base64Str) {
        if (StringUtils.isBlank((CharSequence)base64Str)) {
            return null;
        }
        String fileName = UUID.randomUUID().toString();
        if (base64Str.contains(BASE64_JPEG)) {
            if (StringUtils.isBlank((CharSequence)(base64Str = base64Str.replace(BASE64_JPEG, "")))) {
                return null;
            }
            fileName = fileName + ".jpeg";
        } else if (base64Str.contains(BASE64_PNG)) {
            if (StringUtils.isBlank((CharSequence)(base64Str = base64Str.replace(BASE64_PNG, "")))) {
                return null;
            }
            fileName = fileName + ".png";
        }
        byte[] bytes = this.generateImage(base64Str);
        if (null != bytes) {
            return this.aliyunOSSService.upload(bytes, this.generateDirByFileName(fileName));
        }
        return null;
    }

    private byte[] generateImage(String imgStr) {
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] bytes = decoder.decodeBuffer(imgStr);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] + 256);
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String generateDirByFileName(String fileName) {
        String suffix = this.generateSuffix(fileName);
        String todayStr = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
        return suffix + "/" + todayStr + "/" + fileName;
    }

    private String generateSuffix(String fileName) {
        String suffix = FileUtils.getFilextension((String)fileName);
        String contentType = FileTypeEnum.getContentType((String)suffix);
        if (StringUtils.isBlank((CharSequence)contentType)) {
            suffix = "txt";
        }
        return suffix;
    }
}

