package com.bxm.localnews.activity.service;

import com.bxm.localnews.activity.dto.AppletAppTaskResultDTO;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.vo.BaskInfoMeta;
import com.bxm.localnews.activity.vo.MissionModel;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.common.vo.Json;

import java.util.Map;

/**
 * Created by Administrator on 2018/2/23.
 */
public interface MissionService {

    /**
     * 获取任务列表
     *
     * @param userId
     * @param areaCode
     * @param curVer
     * @param platform
     * @return
     */
    Json<MissionModel> listMissions(Long userId, String areaCode, String curVer, Integer platform);

    /**
     * 获取用户基本收入
     * @param userId
     * @return
     */
    Json<BaskInfoMeta> baskInfo(Long userId);

    /**
     * 设置任务为完成状态
     *
     * @param userId 用户ID
     * @param taskId 任务ID{@link TaskEnum}
     * @return
     */
    void completeDailyTask(Long userId, Byte taskId);

    /**
     * 获取用户日常任务的完成情况
     *
     * @param userId 用户ID
     * @return 完成情况map，key为任务ID，value如果有值，表示已完成
     */
    Map<String, Byte> getDailyTaskStatus(Long userId);

    /**
     * 完成任务
     * @param userId
     * @param taskTypeEnum
     * @param relationId
     * @param content
     * @return
     */
    NewsMissionRewardDto completeTask(Long userId, TaskEnum taskTypeEnum, String relationId, String content);

    /**
     * 完成指定的场景任务,需要新添完成任务,在WxMiniSceneEnum中新添枚举
     *
     * @param userId 用户id
     * @param scene 场景名称
     * @return
     */
    AppletAppTaskResultDTO completeSceneTask(Long userId, String scene);
}
