package com.bxm.localnews.activity.service;

import com.bxm.localnews.activity.dto.UserVipInfoDTO;
import com.bxm.newidea.component.vo.Message;

/**
 * @author zhaoyadong 2018/12/24 19:16
 * @desc
 */
public interface VipFacadeService {

    /**
     * 更新vip邀请记录 说明：userId:表示邀请人， unionId:微信好友查看邀请人的id
     * 微信用户注册时查询用户是否有邀请人并更新邀请人的vip信息，同时绑定本人的vip信息
     *
     * @param userId
     * @param unionId
     * @return
     */
    Message saveVipViewRecord(Long userId, String unionId, Integer platform);

    /**
     * 通过支付购买vip
     *
     * @param userId
     * @return
     */
    Long addUserVipByPay(Long userId);

    /**
     * 检查用户是否激活VIP
     *
     * @param userId
     * @return
     */
    boolean checkUserVip(Long userId);

    /**
     * 更新用户的查看vip的记录
     *
     * @param unionId 微信unionId
     * @return
     */
    Message updateVipViewRecord(String unionId);

    /**
     * 计算用户成功邀请的人数
     * @param userId
     * @return
     */
    Integer countVipByUser(Long userId);

    /**
     * 根据用户id获取VIP信息
     *
     * @param userId
     * @return
     */
    UserVipInfoDTO modifyAndGetUserVip(Long userId, String areaCode);

}
