package com.bxm.localnews.activity.dto;

import java.util.List;

import com.google.common.collect.Lists;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2018/12/24 11:46
 * @desc
 */
@ApiModel(description = "用户vip信息")
public class UserVipInfoDTO extends VipInfoDTO {

    @ApiModelProperty("是否激活vip 1:待激活 2：已激活")
    private Byte activationVip;

    @ApiModelProperty("vip剩余时间（单位：天）")
    private Long remainDay;

    @ApiModelProperty("是否显示引导页 0：不显示 1：显示")
    private Byte showGuide;

    @ApiModelProperty("需要邀请的人数")
    private Long invitedCount;

    @ApiModelProperty("微信用户信息")
    private WechatUserInfoDTO wechatUserInfoDTO;

    @ApiModelProperty("是否显示浮层 0：不显示 1：显示")
    private Byte showLayer;

    @ApiModelProperty("助力的好友列表")
    private List<WechatUserInfoDTO> helpFriendList = Lists.newArrayList();

    @ApiModelProperty("右上角VIP的通知")
    private NoticeDTO notice;

    @ApiModelProperty("激活状态 0表示立即激活 1表示继续激活 2表示出示卡片")
    private Byte activationStatus;

    public Byte getActivationVip() {
        return activationVip;
    }

    public void setActivationVip(Byte activationVip) {
        this.activationVip = activationVip;
    }

    public NoticeDTO getNotice() {
        return notice;
    }

    public void setNotice(NoticeDTO notice) {
        this.notice = notice;
    }

    public Long getRemainDay() {
        return remainDay;
    }

    public void setRemainDay(Long remainDay) {
        this.remainDay = remainDay;
    }

    public Byte getShowGuide() {
        return showGuide;
    }

    public void setShowGuide(Byte showGuide) {
        this.showGuide = showGuide;
    }

    public Long getInvitedCount() {
        return invitedCount;
    }

    public void setInvitedCount(Long invitedCount) {
        this.invitedCount = invitedCount;
    }

    public WechatUserInfoDTO getWechatUserInfoDTO() {
        return wechatUserInfoDTO;
    }

    public void setWechatUserInfoDTO(WechatUserInfoDTO wechatUserInfoDTO) {
        this.wechatUserInfoDTO = wechatUserInfoDTO;
    }

    public Byte getShowLayer() {
        return showLayer;
    }

    public void setShowLayer(Byte showLayer) {
        this.showLayer = showLayer;
    }

    public List<WechatUserInfoDTO> getHelpFriendList() {
        return helpFriendList;
    }

    public void setHelpFriendList(List<WechatUserInfoDTO> helpFriendList) {
        this.helpFriendList = helpFriendList;
    }

    public Byte getActivationStatus() {
        return activationStatus;
    }

    public void setActivationStatus(Byte activationStatus) {
        this.activationStatus = activationStatus;
    }
}
