package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 *     发送的口令红包实体类
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/17
 */
@ApiModel(description = "发送的红包信息")
@Data
public class RedPacketSentDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("红包id")
    private Long         rpId;
    @ApiModelProperty("红包类型：1红包墙 2微信红包")
    private Integer      type;
    @ApiModelProperty("红包金额")
    private String       amount;
    @ApiModelProperty("剩余金额")
    private String       surplusAmount;
    @ApiModelProperty("发布时间")
    private String       publishTime;
    @ApiModelProperty("红包口令")
    private String       content;
    @ApiModelProperty("红包状态值：0等待审核,1审核不通过,2审核通过,3已被领完")
    private Integer status;
    @ApiModelProperty("红包状态显示内容：0等待审核,1审核不通过,2审核通过,3已被领完")
    private String statusStr;

}
