package com.bxm.localnews.activity.param;

import javax.validation.constraints.NotNull;

import com.bxm.localnews.common.vo.BasicParam;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by Arei on 2018/10/25.
 */
@ApiModel(description = "商家传参实体")
public class MerchantParam extends BasicParam {

    @ApiModelProperty("用户id")
    private Long userId;

    @NotNull
    @ApiModelProperty("商户名称")
    private String name;

    @ApiModelProperty("商户类型")
    private String type;

    @NotNull
    @ApiModelProperty("联系人")
    private String contractor;

    @NotNull
    @ApiModelProperty("验证码")
    private String code;

    @NotNull
    @ApiModelProperty("手机号")
    private String phone;

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContractor() {
        return contractor;
    }

    public void setContractor(String contractor) {
        this.contractor = contractor;
    }
}
