/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.domain.InviteRelationMapper;
import com.bxm.localnews.activity.service.InviteRelationService;
import com.bxm.localnews.activity.vo.ApprenticeInfoVo;
import com.bxm.localnews.activity.vo.InviteRelation;
import com.bxm.localnews.activity.vo.ShareMessageVo;
import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.ShortLinkReq;
import com.bxm.localnews.integration.feign.SmsSupplyFeignService;
import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAmount;
import com.bxm.newidea.component.tools.DateUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="inviteRelationService")
public class InviteRelationServiceImpl
implements InviteRelationService {
    private static final Logger logger = LoggerFactory.getLogger(InviteRelationServiceImpl.class);
    private static final String AWAKEN_SHARE_CONTENT = "\u4f60\u5df2\u7ecf\u597d\u4e45\u6ca1\u6765\u672c\u5730\u4e07\u4e8b\u901a\u8d5a\u53d6\u96f6\u82b1\u94b1\u4e86\uff0c\u9001\u4f60500\u91d1\u5e01\uff0c\u8d76\u5feb\u56de\u6765\u8d5a\u94b1\u5427";
    private static final String APPRENTICE_SHARE_TITLE = "\u770b\u65b0\u95fb\u4e5f\u80fd\u8d5a\u53d6\u96f6\u82b1\u94b1\uff01\uff01\uff01";
    private static final String APPRENTICE_SHARE_CONTENT = "\u6211\u5df2\u7ecf\u5728\u672c\u5730\u4e07\u4e8b\u901a\u8d5a\u4e86money\u5143\u4e86\uff0c\u8d76\u5feb\u548c\u6211\u4e00\u8d77\u8d5a\u53d6\u96f6\u82b1\u94b1\u5427";
    @Resource
    private InviteRelationMapper inviteRelationMapper;
    @Resource
    private SmsSupplyFeignService smsSupplyFeignService;
    @Resource
    private UserService userService;
    @Resource
    private ShortLinkService shortLinkService;
    @Resource
    private UserAmountService userAmountService;

    public int addInviteRelation(Long userId, Long masterId) {
        InviteRelation addInviteRelation = new InviteRelation();
        addInviteRelation.setUserId(userId);
        addInviteRelation.setUpUserId(masterId);
        return this.inviteRelationMapper.insertSelective(addInviteRelation);
    }

    private String getWeekStartDate() {
        return ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(DateUtils.getWeekStartDate());
    }

    public Json awakeAllPrentices(Long userId, String ip) {
        List userList = this.inviteRelationMapper.listUnActivePrentices(userId);
        if (userList == null || userList.isEmpty()) {
            return ResultUtil.genFailedResult((String)"\u65e0\u53ef\u5524\u9192\u5f92\u5f1f\u54e6");
        }
        for (User user : userList) {
            String downloadUrl = this.shortLinkService.getDownloadShortUrl();
            this.inviteRelationMapper.awakeUser(user.getId());
            SmsSupplyDTO smsSupplyDTO = new SmsSupplyDTO();
            smsSupplyDTO.setPhoneNo(user.getPhone());
            smsSupplyDTO.setSmsTemplateEnum(SmsTemplateEnum.AWAKE);
            smsSupplyDTO.setIp(ip);
            smsSupplyDTO.setParams(new String[]{downloadUrl});
            this.smsSupplyFeignService.sendSmsByTemplate(smsSupplyDTO);
        }
        return ResultUtil.genSuccessResult((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public int updateUserAwakenState(Long userId) {
        InviteRelation relation = this.inviteRelationMapper.getInviteRelationByUserId(userId);
        if (null == relation) {
            return 1;
        }
        if (30 == relation.getAwakenState()) {
            long hours = Math.abs((System.currentTimeMillis() - relation.getAwakenStartTime().getTime()) / 3600000L);
            if (hours > 24L) {
                this.inviteRelationMapper.updateUserState(relation.getId(), Byte.valueOf((byte)10));
                logger.info(userId + "\u7528\u6237\u5524\u919224\u5c0f\u65f6\u540e\u767b\u5f55");
            } else {
                logger.info(userId + "\u7528\u6237\u5524\u919224\u5c0f\u65f6\u5185\u767b\u5f55");
                this.inviteRelationMapper.updateUserActive(relation.getId());
            }
            return 1;
        }
        if (20 == relation.getAwakenState()) {
            this.inviteRelationMapper.updateUserState(relation.getId(), Byte.valueOf((byte)10));
        }
        return 1;
    }

    public Json<ShareMessageVo> getShareMessage(Long userId, Byte type) {
        ShareMessageVo shareMessageVo = null;
        if (2 == type) {
            shareMessageVo = this.getShareApprenticeMessage(userId);
        }
        if (1 == type) {
            shareMessageVo = this.getShareAwakenMessage(userId);
        }
        return ResultUtil.genSuccessResult((Object)shareMessageVo);
    }

    public Json<ApprenticeInfoVo> getApprenticeInfo(Long userId, Byte type) {
        UserInfoDTO dto = this.userService.getUserFromRedisDB(userId.longValue());
        if (null == dto) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7f3a\u5931\u53c2\u6570");
        }
        ApprenticeInfoVo apprenticeInfoVo = new ApprenticeInfoVo();
        apprenticeInfoVo.setNickName(dto.getNickname());
        if (1 == type) {
            apprenticeInfoVo.setHeadImg(dto.getHeadImg());
            apprenticeInfoVo.setIncome(this.userAmountService.findAmountByUserId(userId).getTotalRmbBalance());
            apprenticeInfoVo.setReward(new BigDecimal(0.5));
        } else {
            apprenticeInfoVo.setReward(new BigDecimal(1.0));
        }
        return ResultUtil.genSuccessResult((Object)apprenticeInfoVo);
    }

    private ShareMessageVo getShareApprenticeMessage(Long userId) {
        UserAmount amount = this.userAmountService.findAmountByUserId(userId);
        String content = APPRENTICE_SHARE_CONTENT.replaceAll("money", amount.getTotalRmbBalance().toString());
        ShortLinkReq req = new ShortLinkReq();
        req.setType(Byte.valueOf((byte)1));
        req.setUserId(userId);
        ShareMessageVo shareMessageVo = new ShareMessageVo(APPRENTICE_SHARE_TITLE, content, this.shortLinkService.getRegisterShortUrl(req));
        return shareMessageVo;
    }

    private ShareMessageVo getShareAwakenMessage(Long userId) {
        ShortLinkReq req = new ShortLinkReq();
        req.setType(Byte.valueOf((byte)2));
        req.setUserId(userId);
        ShareMessageVo shareMessageVo = new ShareMessageVo(APPRENTICE_SHARE_TITLE, AWAKEN_SHARE_CONTENT, this.shortLinkService.getRegisterShortUrl(req));
        return shareMessageVo;
    }
}

