/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.common.constant.TaskStateEnum;
import com.bxm.localnews.activity.common.constant.TaskTypeEnum;
import com.bxm.localnews.activity.domain.DailyTaskMapper;
import com.bxm.localnews.activity.domain.NoviceTaskRecordMapper;
import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.activity.service.VipService;
import com.bxm.localnews.activity.vo.BaskInfoMeta;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.activity.vo.MissionModel;
import com.bxm.localnews.activity.vo.NoviceTaskRecord;
import com.bxm.localnews.activity.vo.UserMissionModel;
import com.bxm.localnews.base.dto.LocationDTO;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.integration.feign.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.user.dto.LocationDetailDTO;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.localnews.user.vo.UserAmount;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="missionService")
@RefreshScope
public class MissionServiceImpl
implements MissionService {
    private static final Logger logger = LoggerFactory.getLogger(MissionServiceImpl.class);
    @Resource
    private DailyTaskMapper dailyTaskMapper;
    private PayFlowService payFlowService;
    @Resource
    private UserAmountService userAmountService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private NoviceTaskRecordMapper noviceTaskRecordMapper;
    @Resource
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;
    @Resource
    private LocationFacadeService locationFacadeService;
    @Resource
    private NewsProperties newsProperties;
    @Resource
    private UserService userService;
    @Resource
    private VipService vipService;
    @Resource
    private AdvertService advertService;
    @Resource
    private AppVersionSupplyService appVersionSupplyService;

    public Json<MissionModel> listMissions(Long userId, String areaCode, String curVer) {
        MissionModel retModel = new MissionModel();
        if (null != userId) {
            List userTask = this.dailyTaskMapper.listMissions(userId);
            Map<String, Byte> dailyTaskMap = this.getDailyTaskStatus(userId);
            int count = 0;
            for (UserMissionModel model : userTask) {
                if (DailyTask.NEWBIEW_TASK.equals(model.getType())) {
                    retModel.addNewbieTask(model);
                    if (1 == model.getNewbiewTaskState()) {
                        ++count;
                    }
                    if (model.getNewbiewTaskCount() == count) {
                        retModel.setNewbieTaskList(new ArrayList());
                    }
                    if (!TaskEnum.TASK_IMPROVE_USER_INFO.getDesc().equals(model.getName())) continue;
                    model.setAddress("tt://perfectData");
                    if (1 != model.getNewbiewTaskState()) continue;
                    model.setCompleted(Boolean.valueOf(true));
                    continue;
                }
                model.setState(Byte.valueOf(dailyTaskMap.get(model.getId().toString()) == null ? (byte)0 : 1));
                String taskName = model.getName();
                TaskEnum taskEnum = TaskEnum.getTaskByDesc((String)taskName);
                KeyGenerator key = null;
                switch (taskEnum) {
                    case TASK_NEWS_READ: {
                        key = RedisConfig.NEWS_READ.copy().setKey(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
                        model.setAddress("tt://readNews");
                        break;
                    }
                    case TASK_NEWS_SHARE: {
                        key = RedisConfig.TASK_SHARE_NEWS_NUM.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
                        model.setAddress("tt://shareWxchat");
                        break;
                    }
                    case TASK_VIDEO_READ: {
                        key = RedisConfig.VIDEO_READ_NUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                        model.setAddress("tt://lookVideo");
                        break;
                    }
                    case TASK_INVITED_FRIEND: {
                        model.setCompleted(Boolean.valueOf(false));
                        model.setAddress("tt://inviteSt");
                        break;
                    }
                    case TASK_ACTIVATION_VIP: {
                        this.checkVipActivation(model, userId, areaCode);
                        model.setAddress("tt://callActivateVip");
                        break;
                    }
                }
                if (key != null) {
                    Integer number = null;
                    number = this.redisStringAdapter.hasKey(key) != false ? this.redisStringAdapter.getInt(key) : Integer.valueOf(0);
                    model.setCompleted(Boolean.valueOf(number >= model.getNumber()));
                    model.setCompletedNum(number);
                    model.setTotalNum(model.getNumber());
                }
                if (taskEnum.equals((Object)TaskEnum.TASK_ACTIVATION_VIP) && model.getCompleted().booleanValue()) continue;
                retModel.addDailyTask(model);
            }
            KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
            Long gainGold = this.redisStringAdapter.getLong(userRewardSumKey);
            retModel.setGainGold(gainGold == null ? null : Integer.valueOf(gainGold.intValue()));
            retModel.setTotalGold(Integer.valueOf(this.newsProperties.getGoldPerDay()));
            retModel = this.sortResult(retModel);
            List<Object> advertDailyTaskList = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)curVer) && this.appVersionSupplyService.isHighVersion(curVer, "1.2.2") != -1) {
                List advertList = this.advertService.queryAdByType(Byte.valueOf((byte)2), areaCode, userId);
                advertDailyTaskList = this.convertAdvert(advertList);
            }
            List dailyTaskList = retModel.getDailyTaskList();
            advertDailyTaskList.addAll(dailyTaskList);
            retModel.setDailyTaskList((List)advertDailyTaskList);
            return ResultUtil.genSuccessResult((Object)retModel);
        }
        List userTask = this.dailyTaskMapper.listDefaultMissions();
        for (UserMissionModel model : userTask) {
            String taskName = model.getName();
            TaskEnum taskEnum = TaskEnum.getTaskByDesc((String)taskName);
            if (taskEnum.equals((Object)TaskEnum.TASK_ACTIVATION_VIP) || taskEnum.equals((Object)TaskEnum.TASK_IMPROVE_USER_INFO)) continue;
            model.setCompleted(Boolean.valueOf(false));
            model.setCompletedNum(Integer.valueOf(0));
            model.setTotalNum(model.getNumber());
            retModel.addDailyTask(model);
        }
        retModel.setGainGold(Integer.valueOf(0));
        retModel.setTotalGold(Integer.valueOf(this.newsProperties.getGoldPerDay()));
        retModel = this.sortResult(retModel);
        return ResultUtil.genSuccessResult((Object)retModel);
    }

    private List<UserMissionModel> convertAdvert(List<AdvertDTO> advertList) {
        ArrayList dailyTaskList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(advertList)) {
            return dailyTaskList;
        }
        advertList.forEach(advertDTO -> {
            UserMissionModel userMissionModel = new UserMissionModel();
            userMissionModel.setAction(advertDTO.getCopy());
            userMissionModel.setHeadImg(advertDTO.getImgUrl());
            userMissionModel.setName(advertDTO.getTaskMaintitle());
            userMissionModel.setRemark(advertDTO.getTaskSubtitle());
            userMissionModel.setAddress(advertDTO.getAddress());
            userMissionModel.setType(UserMissionModel.ADVERT_TASK);
            userMissionModel.setId(advertDTO.getId());
            dailyTaskList.add(userMissionModel);
        });
        return dailyTaskList;
    }

    private void checkVipActivation(UserMissionModel model, Long userId, String areaCode) {
        if (this.vipService.checkUserVip(userId) || this.isShowVipTask(userId, areaCode)) {
            model.setCompleted(Boolean.valueOf(true));
        } else {
            model.setCompleted(Boolean.valueOf(false));
        }
    }

    private boolean isShowVipTask(Long userId, String areaCode) {
        LocationDTO locationDTO = null;
        if (StringUtils.isNotEmpty((CharSequence)areaCode)) {
            locationDTO = this.locationFacadeService.getLocationByCode(areaCode);
        } else {
            LocationDetailDTO locationDetailDTO = this.userService.getLocationByUser(userId);
            if (null != locationDetailDTO) {
                locationDTO = new LocationDTO();
                BeanUtils.copyProperties((Object)locationDetailDTO, (Object)locationDTO);
            }
        }
        if (locationDTO == null) {
            return false;
        }
        return 0 == locationDTO.getEnableVip();
    }

    public Json<BaskInfoMeta> baskInfo(Long userId) {
        UserAmount userAmount = this.userAmountService.findAmountByUserId(userId);
        BaskInfoMeta meta = new BaskInfoMeta();
        meta.setInviteCode(userAmount.getUserId());
        meta.setTotalCoin(userAmount.getTotalRmbBalance());
        return ResultUtil.genSuccessResult((Object)meta);
    }

    public void compleDailyTask(Long userId, Byte taskId) {
        Assert.notNull((Object)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info(LogMarker.BIZ, "[{}]\u5b8c\u6210\u4e86\u4efb\u52a1[{}]", (Object)userId, (Object)taskId);
        KeyGenerator key = this.getDailyTaskCacheKey(userId);
        this.redisHashMapAdapter.put(key, taskId.toString(), (Object)1);
        this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private KeyGenerator getDailyTaskCacheKey(Long userId) {
        return RedisConfig.DAILY_TASK_COMPELE_STATUS.copy().setKey(DateUtils.formatDate((Date)new Date()) + userId);
    }

    public Map<String, Byte> getDailyTaskStatus(Long userId) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Map result = this.redisHashMapAdapter.entries(this.getDailyTaskCacheKey(userId), Byte.class);
        if (result == null) {
            result = Maps.newHashMap();
        }
        return result;
    }

    public Long completeTask(Long userId, TaskEnum taskEnum, String relationId) {
        int num;
        Long reward = null;
        DailyTask dailyTask = this.dailyTaskMapper.selectByName(taskEnum.getDesc());
        if (dailyTask == null) {
            return null;
        }
        if (TaskStateEnum.ENABLE != TaskStateEnum.isAble((int)dailyTask.getState().byteValue())) {
            return null;
        }
        TaskTypeEnum taskType = TaskTypeEnum.getTaskType((int)dailyTask.getType().byteValue());
        if (TaskTypeEnum.NOVICE == taskType) {
            NoviceTaskRecord noviceTaskRecord = this.noviceTaskRecordMapper.findSelectiveByTaskName(taskEnum.getDesc(), userId);
            if (noviceTaskRecord == null) {
                return null;
            }
            if (noviceTaskRecord.getState() == 1) {
                return null;
            }
            noviceTaskRecord.setState(Byte.valueOf((byte)1));
            this.noviceTaskRecordMapper.updateByPrimaryKeySelective(noviceTaskRecord);
            PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)taskEnum.getType(), (Byte)dailyTask.getRewardType(), (String)noviceTaskRecord.getId().toString());
            this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, dailyTask.getReward(), false);
            this.pushMsgSupplyFeignService.pushMsg(this.getPushMsgByTask(userId, dailyTask));
            return dailyTask.getReward().longValue();
        }
        if (TaskTypeEnum.DAILY == taskType && (num = dailyTask.getNumber().intValue()) != 0) {
            boolean isOverGoldPerLimit = false;
            boolean isPush = false;
            boolean isOverNumLimit = false;
            if (num == -1) {
                isPush = true;
            } else if (num > 0) {
                KeyGenerator taskCompleteNumKey = null;
                switch (taskEnum) {
                    case TASK_NEWS_READ: {
                        taskCompleteNumKey = RedisConfig.NEWS_READ.copy().setKey(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
                        break;
                    }
                    case TASK_NEWS_SHARE: {
                        taskCompleteNumKey = RedisConfig.TASK_SHARE_NEWS_NUM.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
                        break;
                    }
                    case TASK_VIDEO_READ: {
                        taskCompleteNumKey = RedisConfig.VIDEO_READ_NUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                        break;
                    }
                    default: {
                        logger.error("TASK-ERR--userId:" + userId + ",taskName:" + taskEnum.name());
                    }
                }
                Integer completeNum = this.redisStringAdapter.getInt(taskCompleteNumKey);
                if (completeNum == null) {
                    completeNum = 0;
                }
                if (completeNum < num) {
                    isOverNumLimit = false;
                    Integer n = completeNum;
                    Integer n2 = completeNum = Integer.valueOf(completeNum + 1);
                    this.redisStringAdapter.set(taskCompleteNumKey, (Object)completeNum);
                    this.redisStringAdapter.expire(taskCompleteNumKey, (long)DateUtils.getCurSeconds());
                    if (completeNum == num) {
                        isPush = true;
                        this.compleDailyTask(userId, taskEnum.getType());
                    }
                } else {
                    isOverNumLimit = true;
                }
            } else {
                logger.error("TASK-NUMBER-ERR--userId:" + userId + ",taskName:" + taskEnum.name());
            }
            KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy().setKey(userId + ":" + DateUtils.formatDate((Date)new Date()));
            Integer totalGoldDay = this.redisStringAdapter.getInt(userRewardSumKey);
            isOverGoldPerLimit = totalGoldDay != null && (totalGoldDay == null || totalGoldDay.compareTo(this.newsProperties.getGoldPerDay()) >= 0);
            if (!isOverGoldPerLimit && !isOverNumLimit) {
                this.redisStringAdapter.incrementWithDefault(userRewardSumKey, dailyTask.getReward().longValue(), dailyTask.getReward().intValue());
                this.redisStringAdapter.expire(userRewardSumKey, (long)DateUtils.getCurSeconds());
                PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)taskEnum.getType(), (Byte)dailyTask.getRewardType(), (String)relationId);
                this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, dailyTask.getReward(), false);
                reward = dailyTask.getReward().longValue();
            }
            if (isPush && !isOverGoldPerLimit) {
                this.pushMsgSupplyFeignService.pushMsg(this.getPushMsgByTask(userId, dailyTask));
            }
        }
        return reward;
    }

    private PushMessage getPushMsgByTask(Long userId, DailyTask dailyTask) {
        String title = "\u4efb\u52a1\u5b8c\u6210";
        BigDecimal goldBalance = this.userAmountService.selectGoldBalanceByUserId(userId);
        String content = "\u606d\u559c\u4f60\u6210\u529f\u5b8c\u6210\u4e86\u3010" + dailyTask.getName() + "\u3011,\u83b7\u5f97" + dailyTask.getReward().longValue() + "\u91d1\u5e01\u76ee\u524d\u5171\u6709" + goldBalance.longValue() + "\u91d1\u5e01";
        return PushMessage.build().setTitle(title).setContent(content).setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId)).setPayloadInfo(PushPayloadInfo.build((PushMessageEnum)TaskEnum.getPushMessageEnumByDesc((String)dailyTask.getName())).addExtend("activityName", (Object)dailyTask.getName()).addExtend("activityReward", (Object)(dailyTask.getReward().longValue() + "")).addExtend("totalGold", (Object)(goldBalance.longValue() + "")));
    }

    private MissionModel sortResult(MissionModel retModel) {
        this.sortList(retModel.getNewbieTaskList());
        this.sortList(retModel.getDailyTaskList());
        return retModel;
    }

    private void sortList(List<UserMissionModel> list) {
        list.sort(Comparator.comparingInt(UserMissionModel::getNewbiewTaskState));
    }

    private PayFlowService getPayFlowService() {
        if (null == this.payFlowService) {
            this.payFlowService = (PayFlowService)SpringContextHolder.getBean(PayFlowService.class);
        }
        return this.payFlowService;
    }
}

