/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.config.VipRankProperties;
import com.bxm.localnews.activity.config.WechatCustomerServiceProperties;
import com.bxm.localnews.activity.constant.VipStatusEnum;
import com.bxm.localnews.activity.domain.VipMapper;
import com.bxm.localnews.activity.domain.VipViewRecordMapper;
import com.bxm.localnews.activity.dto.CustomerServiceDTO;
import com.bxm.localnews.activity.dto.NoticeDTO;
import com.bxm.localnews.activity.dto.UserSuccessFriendDTO;
import com.bxm.localnews.activity.dto.UserVipInfoDTO;
import com.bxm.localnews.activity.dto.WechatUserInfoDTO;
import com.bxm.localnews.activity.dto.WechatVipInfoDTO;
import com.bxm.localnews.activity.param.RecordWechatParam;
import com.bxm.localnews.activity.param.VipParam;
import com.bxm.localnews.activity.param.VipViewRecordParam;
import com.bxm.localnews.activity.service.MovieService;
import com.bxm.localnews.activity.service.VipFacadeService;
import com.bxm.localnews.activity.service.VipService;
import com.bxm.localnews.activity.vo.Vip;
import com.bxm.localnews.activity.vo.VipViewRecord;
import com.bxm.localnews.base.dto.LocationDTO;
import com.bxm.localnews.base.dto.LocationDetailDTO;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.feign.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.service.UserService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
public class VipServiceImpl
extends BaseService
implements VipService,
VipFacadeService {
    private WechatCustomerServiceProperties wechatCustomerServiceProperties;
    private VipRankProperties vipRankProperties;
    private SequenceCreater sequenceCreater;
    private VipMapper vipMapper;
    private VipViewRecordMapper vipViewRecordMapper;
    private RedisSetAdapter redisSetAdapter;
    private RedisStringAdapter redisStringAdapter;
    private LocationFacadeService locationFacadeService;
    private UserService userService;
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;
    private MovieService movieService;
    private BizLogService bizLogService;
    private DistributedLock distributedLock;

    @Autowired
    public VipServiceImpl(WechatCustomerServiceProperties wechatCustomerServiceProperties, VipRankProperties vipRankProperties, SequenceCreater sequenceCreater, VipMapper vipMapper, VipViewRecordMapper vipViewRecordMapper, RedisSetAdapter redisSetAdapter, RedisStringAdapter redisStringAdapter, LocationFacadeService locationFacadeService, UserService userService, PushMsgSupplyFeignService pushMsgSupplyFeignService, MovieService movieService, BizLogService bizLogService, DistributedLock distributedLock) {
        this.wechatCustomerServiceProperties = wechatCustomerServiceProperties;
        this.vipRankProperties = vipRankProperties;
        this.sequenceCreater = sequenceCreater;
        this.vipMapper = vipMapper;
        this.vipViewRecordMapper = vipViewRecordMapper;
        this.redisSetAdapter = redisSetAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.locationFacadeService = locationFacadeService;
        this.userService = userService;
        this.pushMsgSupplyFeignService = pushMsgSupplyFeignService;
        this.movieService = movieService;
        this.bizLogService = bizLogService;
        this.distributedLock = distributedLock;
    }

    public Message saveVipViewRecord(Long userId, String unionId) {
        this.confirmUserRelation(unionId, userId);
        this.updateUserVip(userId, unionId);
        this.updateVipViewRecord(unionId);
        return Message.build();
    }

    public Long addUserVipByPay(Long userId) {
        return this.generateVipByPay(userId);
    }

    public Boolean checkUserActivatedVip(Long userId) {
        return this.checkActivatedVipByUserId(userId);
    }

    public Message updateVipViewRecord(String unionId) {
        this.vipViewRecordMapper.updateViewRecordByUser(unionId);
        return Message.build();
    }

    public Integer countVipByUser(Long userId) {
        return this.vipMapper.countVipByUser(userId);
    }

    @Override
    public WechatVipInfoDTO addWechatUserVip(String areaCode, String wechatUid, String wechatName, String wechatImg) {
        VipParam vipParam = new VipParam();
        vipParam.setWechatUid(wechatUid);
        Vip vip = this.getVip(vipParam);
        if (vip == null) {
            vip = this.generateVip(areaCode, wechatUid, null);
            this.saveUserVip(vip);
            this.saveUserToCache(wechatName, wechatImg);
        } else if (!this.redisStringAdapter.hasKey(this.getUserReceiveVipKey(vip.getWechatUid())).booleanValue()) {
            Date now = new Date();
            Long time = DateUtils.addField((Date)now, (int)12, (int)30).getTime();
            this.redisStringAdapter.set(this.getUserReceiveVipKey(vip.getWechatUid()), (Object)time.toString(), 1800L);
        }
        return this.convertVip(vip, areaCode);
    }

    private void saveUserVip(Vip vip) {
        String randomId = this.sequenceCreater.nextStringId();
        if (this.distributedLock.lock(vip.getWechatUid(), randomId, 1L, TimeUnit.SECONDS)) {
            VipParam vipParam = new VipParam();
            vipParam.setWechatUid(vip.getWechatUid());
            if (this.vipMapper.selectVipByUser(vipParam) == null) {
                this.vipMapper.insertSelective(vip);
            }
        }
    }

    @Override
    public UserSuccessFriendDTO getSuccessFriend(Long userId) {
        return this.getUserSuccessFriend(userId);
    }

    @Override
    public List<WechatUserInfoDTO> getInviteFriendRecord(Long userId) {
        VipViewRecordParam vipViewRecordParam = new VipViewRecordParam();
        vipViewRecordParam.setUserId(userId);
        vipViewRecordParam.setDisplayFlag(Byte.valueOf((byte)1));
        return this.getWechatUserList(vipViewRecordParam);
    }

    @Override
    public Message addViewRecord(RecordWechatParam recordWechatParam) {
        Message message = Message.build();
        VipViewRecord vipViewRecord = this.vipViewRecordMapper.getViewRecordByUserAndWechatUid(recordWechatParam);
        if (vipViewRecord != null) {
            if (vipViewRecord.getDisplayFlag() == 0) {
                return message;
            }
            vipViewRecord.setViewTime(new Date());
            this.vipViewRecordMapper.updateByPrimaryKey(vipViewRecord);
            return message;
        }
        if (this.userService.checkUnionIdIsUser(recordWechatParam.getWechatUid()).booleanValue()) {
            return message;
        }
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(recordWechatParam.getUserId().longValue());
        if (recordWechatParam.getWechatUid().equals(userInfoDTO.getWeixin())) {
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)recordWechatParam.getWechatImg())) {
            recordWechatParam.setWechatImg(this.userService.getDefaultHeadImgUrl());
        }
        this.vipViewRecordMapper.insertSelective(this.generateVipViewRecord(recordWechatParam));
        return Message.build();
    }

    @Override
    public CustomerServiceDTO getCustomerService() {
        CustomerServiceDTO customerServiceDTO = new CustomerServiceDTO();
        customerServiceDTO.setCustomerServiceName(this.wechatCustomerServiceProperties.getCustomerServiceName());
        customerServiceDTO.setCustomerServiceImg(this.wechatCustomerServiceProperties.getCustomerServiceImg());
        return customerServiceDTO;
    }

    @Override
    public Message modifyUserGuid(Long userId) {
        this.vipMapper.updateUserGuide(userId);
        return Message.build();
    }

    @Override
    public UserVipInfoDTO modifyAndGetUserVip(Long userId, String areaCode) {
        UserInfoDTO userInfoDTO;
        VipParam vipParam = new VipParam();
        vipParam.setUserId(userId);
        Vip vip = this.getVip(vipParam);
        if (vip == null) {
            userInfoDTO = this.userService.getUserFromRedisDB(userId.longValue());
            if (StringUtils.isNotEmpty((CharSequence)userInfoDTO.getWeixin())) {
                vipParam = new VipParam();
                vipParam.setWechatUid(userInfoDTO.getWeixin());
                vip = this.getVip(vipParam);
                if (vip == null) {
                    vip = this.generateVip(areaCode, userInfoDTO.getWeixin(), userId);
                    this.saveUserVip(vip);
                }
            } else {
                vip = this.generateVip(areaCode, null, userId);
            }
        }
        if (StringUtils.isEmpty((CharSequence)vip.getWechatUid()) && StringUtils.isNotEmpty((CharSequence)(userInfoDTO = this.userService.getUserFromRedisDB(userId.longValue())).getWeixin())) {
            vip.setWechatUid(userInfoDTO.getWeixin());
            this.vipMapper.updateUserVip(vip);
        }
        if (vip.getUserId() == null) {
            this.updateUserVip(userId, vip.getWechatUid());
        }
        return this.convertUserVip(vip);
    }

    @Override
    public boolean checkUserVip(Long userId) {
        return this.checkActivatedVipByUserId(userId);
    }

    private Boolean checkActivatedVipByUserId(Long userId) {
        VipParam vipParam = new VipParam();
        vipParam.setUserId(userId);
        Vip vip = this.getVip(vipParam);
        if (null != vip && VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public WechatVipInfoDTO getWechatVip(String unionId, String areaCode) {
        VipParam vipParam = new VipParam();
        vipParam.setWechatUid(unionId);
        Vip vip = this.getVip(vipParam);
        return this.convertVip(vip, areaCode);
    }

    private Vip getVip(VipParam vipParam) {
        return this.vipMapper.selectVipByUser(vipParam);
    }

    @Override
    public List<WechatUserInfoDTO> getVipRank() {
        List<WechatUserInfoDTO> list = this.getUserVipRank().stream().collect(Collectors.toList());
        return list;
    }

    @Override
    public Message modifyUserShowLayer(Long userId) {
        this.redisStringAdapter.set(this.getUserShowLayerKey(userId), 1L);
        return Message.build();
    }

    @Override
    public Vip getVipByUser(Long userId) {
        VipParam vipParam = new VipParam();
        vipParam.setUserId(userId);
        return this.vipMapper.selectVipByUser(vipParam);
    }

    @Override
    public List<WechatUserInfoDTO> getAllSuccessWechatUserList(Long userId) {
        return this.getListByUserId(userId);
    }

    private WechatVipInfoDTO convertVip(Vip vip, String areaCode) {
        LocationDetailDTO locationDetailDTO;
        WechatVipInfoDTO wechatVipInfoDTO = new WechatVipInfoDTO();
        if (vip == null) {
            wechatVipInfoDTO.setActivationVip(VipStatusEnum.RECEIVE_NOT_LOGIN.getType());
            return wechatVipInfoDTO;
        }
        wechatVipInfoDTO.setNum(vip.getNum());
        wechatVipInfoDTO.setSource(vip.getSource());
        if (vip.getUserId() == null) {
            wechatVipInfoDTO.setActivationVip(VipStatusEnum.RECEIVE_NOT_LOGIN.getType());
            if (this.redisStringAdapter.hasKey(this.getUserReceiveVipKey(vip.getWechatUid())).booleanValue()) {
                wechatVipInfoDTO.setRemainDate(this.redisStringAdapter.getLong(this.getUserReceiveVipKey(vip.getWechatUid())));
            }
        }
        if ((locationDetailDTO = this.locationFacadeService.getLocationDetailByCode(areaCode)) != null) {
            wechatVipInfoDTO.setApplyArea(locationDetailDTO.getFullName());
            wechatVipInfoDTO.setAreaName(locationDetailDTO.getName());
        }
        if (vip.getUserId() != null) {
            wechatVipInfoDTO.setActivationVip(vip.getStatus());
        }
        return wechatVipInfoDTO;
    }

    private UserVipInfoDTO convertUserVip(Vip vip) {
        List<WechatUserInfoDTO> list;
        com.bxm.localnews.user.dto.LocationDetailDTO locationDetailDTO;
        UserInfoDTO userInfoDTO;
        UserVipInfoDTO userVipInfoDTO = new UserVipInfoDTO();
        userVipInfoDTO.setNum(vip.getNum());
        userVipInfoDTO.setInvitedCount(Long.valueOf(vip.getInvitedCount() == null ? 3L : Long.valueOf(vip.getInvitedCount().intValue())));
        userVipInfoDTO.setShowGuide(vip.getShowGuide());
        userVipInfoDTO.setActivationVip(vip.getStatus());
        userVipInfoDTO.setSource(vip.getSource());
        if (VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus())) {
            NoticeDTO notice;
            Date now = new Date();
            Integer remainDay = DateUtils.getDiffDays((Date)vip.getExpiredDate(), (Date)now, (boolean)Boolean.FALSE);
            if (remainDay <= 0) {
                remainDay = -1;
            }
            if (remainDay > 0 && null != (notice = this.movieService.getMovieVipNotice(vip.getUserId()))) {
                userVipInfoDTO.setNotice(notice);
            }
            userVipInfoDTO.setRemainDay(Long.valueOf(remainDay + 1));
            userVipInfoDTO.setActivationStatus(Byte.valueOf((byte)2));
        }
        if ((userInfoDTO = this.userService.getUserFromRedisDB(vip.getUserId().longValue())) != null) {
            WechatUserInfoDTO wechatUserInfoDTO = new WechatUserInfoDTO();
            wechatUserInfoDTO.setWechatName(userInfoDTO.getNickname());
            wechatUserInfoDTO.setWechatImg(userInfoDTO.getHeadImg());
            userVipInfoDTO.setWechatUserInfoDTO(wechatUserInfoDTO);
        }
        if ((locationDetailDTO = this.userService.getLocationByUser(vip.getUserId())) != null) {
            userVipInfoDTO.setAreaName(locationDetailDTO.getName());
            userVipInfoDTO.setApplyArea(locationDetailDTO.getFullName());
            userVipInfoDTO.setReductionAmount(locationDetailDTO.getReductionAmount());
        }
        if (!VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus())) {
            userVipInfoDTO.setShowLayer(this.getUserShowlayer(vip.getUserId(), vip.getStatus()));
            if (userVipInfoDTO.getShowLayer() == 1) {
                list = this.getListByUserId(vip.getUserId());
                userVipInfoDTO.setHelpFriendList(list);
                if (CollectionUtils.isEmpty(list)) {
                    userVipInfoDTO.setShowLayer(Byte.valueOf((byte)0));
                }
                if (CollectionUtils.isNotEmpty(list) && list.size() < vip.getInvitedCount()) {
                    userVipInfoDTO.setShowLayer(this.expireUserShowLayer(vip.getUserId()));
                }
            }
            VipViewRecordParam vipViewRecordParam = new VipViewRecordParam();
            vipViewRecordParam.setUserId(vip.getUserId());
            List<WechatUserInfoDTO> recordlist = this.getWechatUserList(vipViewRecordParam);
            if (CollectionUtils.isEmpty(recordlist)) {
                userVipInfoDTO.setActivationStatus(Byte.valueOf((byte)0));
            } else {
                userVipInfoDTO.setActivationStatus(Byte.valueOf((byte)1));
            }
        }
        if (userVipInfoDTO.getShowGuide() == 1) {
            list = this.getListByUserId(vip.getUserId());
            userVipInfoDTO.setHelpFriendList(list);
        }
        if (VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus())) {
            userVipInfoDTO.setShowLayer(Byte.valueOf((byte)0));
        }
        return userVipInfoDTO;
    }

    private List<WechatUserInfoDTO> getListByUserId(Long userId) {
        VipViewRecordParam vipViewRecordParam = new VipViewRecordParam();
        vipViewRecordParam.setUserId(userId);
        vipViewRecordParam.setChecked(Byte.valueOf((byte)1));
        return this.getWechatUserList(vipViewRecordParam);
    }

    private Vip generateVip(String areaCode, String wechatUid, Long userId) {
        LocationDTO locationDTO;
        Vip vip = new Vip();
        vip.setId(this.sequenceCreater.nextLongId());
        vip.setNum(this.generateVipNum());
        if (userId != null) {
            vip.setUserId(userId);
        }
        if ((locationDTO = this.locationFacadeService.getLocationByCode(areaCode)) == null || locationDTO.getInvitedCount() == null) {
            locationDTO = this.locationFacadeService.getAcitivateVipLocation();
            this.logger.error("\u7528\u6237id:{},\u7528\u6237\u5fae\u4fe1:{},\u5f53\u524d\u5730\u533a:{},\u7ecf\u68c0\u6d4b\u5e76\u65e0\u5f00\u901aVIP,\u5730\u533a\u8f6c\u6362\u4e3a:{}", new Object[]{userId, wechatUid, areaCode, locationDTO.getName()});
        }
        vip.setActivationAreaCode(locationDTO.getCode());
        vip.setInvitedCount(locationDTO.getInvitedCount());
        vip.setWechatUid(wechatUid);
        Date now = new Date();
        vip.setCreateTime(now);
        vip.setWechatUid(wechatUid);
        vip.setSource(Byte.valueOf((byte)1));
        vip.setStatus(VipStatusEnum.INACTIVATE.getType());
        vip.setShowGuide(Byte.valueOf((byte)0));
        Long time = DateUtils.addField((Date)now, (int)12, (int)30).getTime();
        if (StringUtils.isNotEmpty((CharSequence)wechatUid)) {
            this.redisStringAdapter.set(this.getUserReceiveVipKey(wechatUid), (Object)time.toString(), 1800L);
        }
        return vip;
    }

    private String generateVipNum() {
        Set set = this.redisSetAdapter.getAllMembers(this.getUserVipNumKey(), Integer.class);
        Integer num = this.getRandomIntInRangeWithExclude(10000000, 99999999, set);
        this.redisSetAdapter.add(this.getUserVipNumKey(), new Object[]{num});
        return String.valueOf(num);
    }

    private WechatUserInfoDTO convertVipViewRecord(VipViewRecord vipViewRecord) {
        WechatUserInfoDTO wechatUserInfoDTO = new WechatUserInfoDTO();
        wechatUserInfoDTO.setWechatImg(vipViewRecord.getWechatImg());
        wechatUserInfoDTO.setWechatName(vipViewRecord.getWechatName());
        return wechatUserInfoDTO;
    }

    private UserSuccessFriendDTO getUserSuccessFriend(Long userId) {
        UserSuccessFriendDTO userSuccessFriendDTO = new UserSuccessFriendDTO();
        VipViewRecordParam vipViewRecordParam = new VipViewRecordParam();
        vipViewRecordParam.setUserId(userId);
        vipViewRecordParam.setChecked(Byte.valueOf((byte)1));
        List<WechatUserInfoDTO> list = this.getWechatUserList(vipViewRecordParam);
        VipParam vipParam = new VipParam();
        vipParam.setUserId(userId);
        Vip vip = this.getVip(vipParam);
        userSuccessFriendDTO.setHelpFriendList(list);
        userSuccessFriendDTO.setInvitedCount(Long.valueOf(vip.getInvitedCount() == null ? 3L : Long.valueOf(vip.getInvitedCount().intValue())));
        if (CollectionUtils.isNotEmpty(list) && list.size() > vip.getInvitedCount()) {
            ArrayList userInfoDTOList = Lists.newArrayList();
            int i = 0;
            while ((long)i < userSuccessFriendDTO.getInvitedCount()) {
                userInfoDTOList.add(list.get(i));
                ++i;
            }
            userSuccessFriendDTO.setHelpFriendList((List)userInfoDTOList);
        }
        vipViewRecordParam = new VipViewRecordParam();
        vipViewRecordParam.setUserId(userId);
        vipViewRecordParam.setDisplayFlag(Byte.valueOf((byte)1));
        List<WechatUserInfoDTO> viewList = this.getWechatUserList(vipViewRecordParam);
        userSuccessFriendDTO.setViewCount(Long.valueOf(viewList.size()));
        return userSuccessFriendDTO;
    }

    private List<WechatUserInfoDTO> getWechatUserList(VipViewRecordParam vipViewRecordParam) {
        List vipViewRecordList = this.vipViewRecordMapper.selectVipRecordList(vipViewRecordParam);
        List<WechatUserInfoDTO> list = vipViewRecordList.stream().map(this::convertVipViewRecord).collect(Collectors.toList());
        VipParam vipParam = new VipParam();
        vipParam.setUserId(vipViewRecordParam.getUserId());
        return list;
    }

    private VipViewRecord generateVipViewRecord(RecordWechatParam recordWechatParam) {
        VipViewRecord vipViewRecord = new VipViewRecord();
        vipViewRecord.setId(this.sequenceCreater.nextLongId());
        BeanUtils.copyProperties((Object)recordWechatParam, (Object)vipViewRecord);
        vipViewRecord.setDisplayFlag(Byte.valueOf((byte)1));
        vipViewRecord.setViewTime(new Date());
        return vipViewRecord;
    }

    private KeyGenerator getUserVipRankKey() {
        return RedisConfig.USER_VIP_RANK.copy();
    }

    private KeyGenerator getUserVipRankImgKey() {
        return RedisConfig.USER_VIP_RANK_IMG.copy();
    }

    private KeyGenerator getUserVipNumKey() {
        return RedisConfig.USER_VIP_NUM_RECORD.copy();
    }

    private KeyGenerator getUserReceiveVipKey(String wechatUid) {
        return RedisConfig.USER_RECEIVE_VIP_TIME.copy().appendKey((Object)wechatUid);
    }

    private KeyGenerator getUserLayerExpireTimeKey(Long userId) {
        return RedisConfig.USER_LAYER_EXPIRE_TIME.copy().appendKey((Object)userId);
    }

    private KeyGenerator getUserShowLayerKey(Long userId) {
        return RedisConfig.USER_SHOW_LAYER.copy().appendKey((Object)userId);
    }

    private Integer getRandomIntInRangeWithExclude(int min, int max, Set<Integer> exclude) {
        Random random = new Random();
        return random.ints(min, max + 1).filter(r -> !exclude.contains(r)).limit(1L).findFirst().getAsInt();
    }

    private Set<String> getUserVipRankByCache() {
        Set<Object> set = Sets.newHashSet();
        if (this.redisSetAdapter.hasKey(this.getUserVipRankKey()).booleanValue()) {
            set = this.redisSetAdapter.getAllMembers(this.getUserVipRankKey(), String.class);
        }
        if (CollectionUtils.isEmpty((Collection)set)) {
            List<String> list = this.vipRankProperties.getRank();
            set = list.stream().collect(Collectors.toSet());
            Object[] objects = list.stream().toArray();
            if (CollectionUtils.isNotEmpty(list)) {
                this.redisSetAdapter.add(this.getUserVipRankKey(), objects);
            }
        }
        return set;
    }

    private Set<WechatUserInfoDTO> getUserVipRank() {
        Set<Object> set = Sets.newHashSet();
        if (this.redisSetAdapter.hasKey(this.getUserVipRankKey()).booleanValue()) {
            TypeReference<WechatUserInfoDTO> wechatUserInfoDTOTypeReference = new TypeReference<WechatUserInfoDTO>(){};
            set = this.redisSetAdapter.getAllMembers(this.getUserVipRankKey(), (TypeReference)wechatUserInfoDTOTypeReference);
        }
        if (CollectionUtils.isEmpty((Collection)set)) {
            List<String> list = this.vipRankProperties.getRank();
            List<String> imgList = this.vipRankProperties.getRankImg();
            set = this.convertNameAndImg(list, imgList);
            Object[] objects = set.stream().toArray();
            if (CollectionUtils.isNotEmpty(list)) {
                this.redisSetAdapter.add(this.getUserVipRankKey(), objects);
            }
        }
        return set;
    }

    private Set<WechatUserInfoDTO> convertNameAndImg(List<String> list, List<String> imgList) {
        HashSet wechatUserInfoDTOS = Sets.newHashSet();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            WechatUserInfoDTO wechatUserInfoDTO = new WechatUserInfoDTO();
            wechatUserInfoDTO.setWechatName(list.get(i));
            wechatUserInfoDTO.setWechatImg(imgList.get(i));
            wechatUserInfoDTOS.add(wechatUserInfoDTO);
        }
        return wechatUserInfoDTOS;
    }

    private WechatUserInfoDTO convertString(String name) {
        WechatUserInfoDTO wechatUserInfoDTO = new WechatUserInfoDTO();
        wechatUserInfoDTO.setWechatName(name);
        return wechatUserInfoDTO;
    }

    private void confirmUserRelation(String unionId, Long userId) {
        VipViewRecord vipViewRecord = this.vipViewRecordMapper.getCheckedByWechatUid(unionId);
        if (vipViewRecord != null) {
            return;
        }
        vipViewRecord = this.vipViewRecordMapper.getLastVipViewRecord(unionId);
        if (vipViewRecord == null) {
            return;
        }
        Date now = new Date();
        vipViewRecord.setCheckTime(now);
        vipViewRecord.setDisplayFlag(Byte.valueOf((byte)0));
        vipViewRecord.setChecked(Byte.valueOf((byte)1));
        int updateSuccess = this.vipViewRecordMapper.updateByPrimaryKey(vipViewRecord);
        if (updateSuccess > 0) {
            VipParam vipParam = new VipParam();
            vipParam.setUserId(vipViewRecord.getUserId());
            Vip vip = this.getVip(vipParam);
            if (vip == null) {
                return;
            }
            if (VipStatusEnum.INACTIVATE.getType().equals(vip.getStatus())) {
                this.activationVip(vip, vipViewRecord.getWechatName());
            }
            this.bizLogService.inviteVip(userId);
        }
    }

    private void activationVip(Vip vip, String wechatName) {
        VipViewRecordParam vipViewRecordParam = new VipViewRecordParam();
        vipViewRecordParam.setUserId(vip.getUserId());
        vipViewRecordParam.setChecked(Byte.valueOf((byte)1));
        List<WechatUserInfoDTO> list = this.getWechatUserList(vipViewRecordParam);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.redisStringAdapter.remove(this.getUserLayerExpireTimeKey(vip.getUserId()));
        if (list.size() < vip.getInvitedCount()) {
            this.pushHelpMessage(vip.getUserId(), wechatName, vip.getInvitedCount() - list.size());
        }
        if (list.size() >= vip.getInvitedCount()) {
            Date now = new Date();
            vip.setModifyTime(now);
            vip.setActivationDate(now);
            vip.setExpiredDate(DateUtils.addField((Date)now, (int)1, (int)1));
            vip.setStatus(VipStatusEnum.ACTIVATED.getType());
            vip.setShowGuide(Byte.valueOf((byte)1));
            this.vipMapper.updateUserVip(vip);
            this.removeUserLayer(vip.getUserId());
            this.movieService.doGeneratorMovie(vip.getUserId(), vip.getActivationAreaCode());
            this.pushActivationVipSuccessMessage(vip.getUserId());
            this.bizLogService.activateVip(vip.getUserId());
        }
    }

    private void removeUserLayer(Long userId) {
        this.redisStringAdapter.remove(this.getUserShowLayerKey(userId));
    }

    private void saveUserToCache(Long userId) {
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId.longValue());
        if (this.redisSetAdapter.size(this.getUserVipRankKey()) >= 20L) {
            this.redisSetAdapter.pop(this.getUserVipRankKey(), Long.valueOf(1L), String.class);
        }
        this.redisSetAdapter.add(this.getUserVipRankKey(), new Object[]{userInfoDTO.getNickname()});
    }

    private void saveUserToCache(String wechaName, String wechatImg) {
        TypeReference<WechatUserInfoDTO> wechatUserInfoDTOTypeReference = new TypeReference<WechatUserInfoDTO>(){};
        if (this.redisSetAdapter.size(this.getUserVipRankKey()) >= 50L) {
            this.redisSetAdapter.pop(this.getUserVipRankKey(), Long.valueOf(1L), (TypeReference)wechatUserInfoDTOTypeReference);
        }
        WechatUserInfoDTO wechatUserInfoDTO = new WechatUserInfoDTO();
        wechatUserInfoDTO.setWechatImg(wechatImg);
        wechatUserInfoDTO.setWechatName(wechaName);
        ArrayList wechatUserInfoDTOS = Lists.newArrayList((Object[])new WechatUserInfoDTO[]{wechatUserInfoDTO});
        this.redisSetAdapter.add(this.getUserVipRankKey(), wechatUserInfoDTOS.stream().toArray());
    }

    private void updateUserVip(Long userId, String unionId) {
        VipParam vipParam = new VipParam();
        vipParam.setWechatUid(unionId);
        Vip vip = this.getVip(vipParam);
        if (vip == null || vip.getUserId() != null) {
            return;
        }
        vip.setUserId(userId);
        this.vipMapper.updateUserVip(vip);
    }

    private void pushHelpMessage(Long userId, String wechatName, Integer number) {
        String title = "\u3010VIP\u6fc0\u6d3b\u8fdb\u5ea6\u3011" + wechatName + "\u5df2\u6210\u529f\u52a9\u529b\u60a8\uff0c\u8fd8\u5dee" + number + "\u4eba\u53ef\u6fc0\u6d3bVIP";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.VIP_FRIEND_HELP);
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(title);
        message.setType(TemplateTypeEnum.TRANSMISSION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsgSupplyFeignService.pushMsg(message);
    }

    private void pushActivationVipSuccessMessage(Long userId) {
        String title = "\u606d\u559c\uff01\u60a8\u5df2\u6210\u529f\u6fc0\u6d3bVIP\u5361\uff0c\u5149\u4e34\u7ebf\u4e0b\u5408\u4f5c\u95e8\u5e97\uff0c\u7545\u4eab\u6298\u6263";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.VIP_ACTIVATION_SUCCESS);
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(title);
        message.setType(TemplateTypeEnum.TRANSMISSION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsgSupplyFeignService.pushMsg(message);
    }

    private Byte getUserShowlayer(Long userId, Byte status) {
        Boolean isSuccessVip = VipStatusEnum.ACTIVATED.getType().equals(status);
        if (isSuccessVip.booleanValue()) {
            return (byte)0;
        }
        return this.remainLayer(userId);
    }

    private Byte remainLayer(Long userId) {
        if (this.redisStringAdapter.hasKey(this.getUserShowLayerKey(userId)).booleanValue()) {
            return (byte)0;
        }
        return (byte)1;
    }

    private Byte expireUserShowLayer(Long userId) {
        if (this.redisStringAdapter.hasKey(this.getUserLayerExpireTimeKey(userId)).booleanValue()) {
            return (byte)0;
        }
        this.redisStringAdapter.set(this.getUserLayerExpireTimeKey(userId), (Object)DateUtils.getCurrentDateTime(), 86400L);
        return (byte)1;
    }

    private Long generateVipByPay(Long userId) {
        VipParam vipParam = new VipParam();
        vipParam.setUserId(userId);
        Vip vip = this.getVip(vipParam);
        Boolean isUpdate = Boolean.FALSE;
        if (vip == null) {
            UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId.longValue());
            isUpdate = Boolean.TRUE;
            vip = this.generateVip(this.userService.getLocationByUser(userId).getCode(), userInfoDTO.getWeixin(), userId);
        }
        if (VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus())) {
            return null;
        }
        vip.setSource(Byte.valueOf((byte)2));
        Date now = new Date();
        vip.setModifyTime(now);
        vip.setActivationDate(now);
        vip.setExpiredDate(DateUtils.addField((Date)now, (int)1, (int)1));
        vip.setStatus(VipStatusEnum.ACTIVATED.getType());
        vip.setShowGuide(Byte.valueOf((byte)1));
        if (isUpdate.booleanValue()) {
            this.saveUserVip(vip);
        } else {
            this.vipMapper.updateUserVip(vip);
        }
        this.logger.info("\u7528\u6237[{}]\u8d2d\u4e70vip\u6210\u529f", (Object)userId);
        this.movieService.doGeneratorMovie(userId, vip.getActivationAreaCode());
        this.bizLogService.buyVip(userId);
        this.pushActivationVipSuccessMessage(userId);
        this.removeUserLayer(vip.getUserId());
        return vip.getId();
    }
}

