/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.common.constant.TaskStateEnum;
import com.bxm.localnews.activity.common.constant.TaskTypeEnum;
import com.bxm.localnews.activity.domain.DailyTaskMapper;
import com.bxm.localnews.activity.domain.NoviceTaskRecordMapper;
import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.activity.service.VipService;
import com.bxm.localnews.activity.vo.BaskInfoMeta;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.activity.vo.MissionModel;
import com.bxm.localnews.activity.vo.NoviceTaskRecord;
import com.bxm.localnews.activity.vo.UserMissionModel;
import com.bxm.localnews.base.dto.LocationFacadeDTO;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDetailDTO;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="missionService")
public class MissionServiceImpl
implements MissionService {
    private static final Logger logger = LoggerFactory.getLogger(MissionServiceImpl.class);
    @Resource
    private DailyTaskMapper dailyTaskMapper;
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private NoviceTaskRecordMapper noviceTaskRecordMapper;
    @Resource
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;
    @Resource
    private LocationFacadeService locationFacadeService;
    @Resource
    private NewsProperties newsProperties;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private VipService vipService;
    @Resource
    private AdvertService advertService;
    @Resource
    private AppVersionSupplyService appVersionSupplyService;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private SequenceCreater sequenceCreater;

    public Json<MissionModel> listMissions(Long userId, String areaCode, String curVer) {
        MissionModel retModel = new MissionModel();
        if (null != userId) {
            List userTask = this.dailyTaskMapper.listMissions(userId);
            Map<String, Byte> dailyTaskMap = this.getDailyTaskStatus(userId);
            int count = 0;
            LocationFacadeDTO locationFacadeDTO = this.getLocation(userId, areaCode);
            Boolean isVip = this.checkVipAcvation(userId, locationFacadeDTO);
            Boolean isPost = this.checkPost(locationFacadeDTO);
            for (UserMissionModel model : userTask) {
                if (DailyTask.NEWBIEW_TASK.equals(model.getType())) {
                    retModel.addNewbieTask(model);
                    if (1 == model.getNewbiewTaskState()) {
                        ++count;
                    }
                    if (model.getNewbiewTaskCount() == count) {
                        retModel.setNewbieTaskList(new ArrayList());
                    }
                    if (TaskEnum.TASK_IMPROVE_INFO.getDesc().equals(model.getName())) {
                        model.setAddress("tt://perfectData");
                        if (1 == model.getNewbiewTaskState()) {
                            model.setCompleted(Boolean.valueOf(true));
                        }
                    }
                    if (!TaskEnum.TASK_FIRST_POST_INTIVATION.getDesc().equals(model.getName())) continue;
                    model.setAddress("tt://postInvitation");
                    if (1 != model.getNewbiewTaskState() && isPost.booleanValue()) continue;
                    model.setCompleted(Boolean.valueOf(true));
                    continue;
                }
                model.setState(Byte.valueOf(dailyTaskMap.get(model.getId().toString()) == null ? (byte)0 : 1));
                String taskName = model.getName();
                TaskEnum taskEnum = TaskEnum.getTaskByDesc((String)taskName);
                KeyGenerator key = null;
                switch (taskEnum) {
                    case TASK_NEWS_READ: {
                        key = RedisConfig.NEWS_READ.copy().setKey(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
                        model.setAddress("tt://readNews");
                        break;
                    }
                    case TASK_NEWS_SHARE: {
                        key = RedisConfig.TASK_SHARE_NEWS_NUM.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
                        model.setAddress("tt://shareWxchat");
                        break;
                    }
                    case TASK_VIDEO_READ: {
                        key = RedisConfig.VIDEO_READ_NUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                        model.setAddress("tt://lookVideo");
                        break;
                    }
                    case TASK_INVITED_FRIEND: {
                        model.setCompleted(Boolean.valueOf(false));
                        model.setAddress("tt://inviteSt");
                        break;
                    }
                    case TASK_ACTIVATION_VIP: {
                        model.setCompleted(isVip);
                        model.setAddress("tt://callActivateVip");
                        break;
                    }
                    case TASK_POST_INTIVATION: {
                        model.setCompleted(isPost);
                        key = RedisConfig.POST_FORUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                        model.setAddress("tt://postInvitation");
                        break;
                    }
                }
                if (key != null) {
                    Integer number = null;
                    number = this.redisStringAdapter.hasKey(key) != false ? this.redisStringAdapter.getInt(key) : Integer.valueOf(0);
                    model.setCompleted(Boolean.valueOf(number >= model.getNumber()));
                    model.setCompletedNum(number);
                    model.setTotalNum(model.getNumber());
                }
                if (taskEnum.equals((Object)TaskEnum.TASK_ACTIVATION_VIP) && model.getCompleted().booleanValue()) continue;
                retModel.addDailyTask(model);
            }
            KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
            logger.debug("\u4eceredis\u83b7\u53d6\u7528\u6237[{}]\u5f53\u5929\u5b8c\u6210\u4efb\u52a1\u83b7\u5f97\u5956\u52b1\u91d1\u5e01\u603b\u6570", (Object)userId);
            Long gainGold = this.redisStringAdapter.getLong(userRewardSumKey);
            retModel.setGainGold(gainGold == null ? null : Integer.valueOf(gainGold.intValue()));
            retModel.setTotalGold(Integer.valueOf(this.newsProperties.getGoldPerDay()));
            retModel = this.sortResult(retModel);
            List<Object> advertDailyTaskList = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)curVer) && this.appVersionSupplyService.isHighVersion(curVer, "1.2.2") != -1) {
                List advertList = this.advertService.queryAdByType(Byte.valueOf((byte)2), areaCode, userId);
                advertDailyTaskList = this.convertAdvert(advertList);
            }
            List dailyTaskList = retModel.getDailyTaskList();
            if (!isPost.booleanValue()) {
                dailyTaskList = dailyTaskList.stream().filter(userMissionModel -> !userMissionModel.getName().equals(TaskEnum.TASK_POST_INTIVATION.getDesc())).collect(Collectors.toList());
            }
            dailyTaskList.addAll(advertDailyTaskList);
            retModel.setDailyTaskList(dailyTaskList);
            return ResultUtil.genSuccessResult((Object)retModel);
        }
        List userTask = this.dailyTaskMapper.listDefaultMissions();
        for (UserMissionModel model : userTask) {
            String taskName = model.getName();
            TaskEnum taskEnum = TaskEnum.getTaskByDesc((String)taskName);
            if (taskEnum.equals((Object)TaskEnum.TASK_ACTIVATION_VIP) || taskEnum.equals((Object)TaskEnum.TASK_IMPROVE_INFO)) continue;
            model.setCompleted(Boolean.valueOf(false));
            model.setCompletedNum(Integer.valueOf(0));
            model.setTotalNum(model.getNumber());
            retModel.addDailyTask(model);
        }
        retModel.setGainGold(Integer.valueOf(0));
        retModel.setTotalGold(Integer.valueOf(this.newsProperties.getGoldPerDay()));
        retModel = this.sortResult(retModel);
        return ResultUtil.genSuccessResult((Object)retModel);
    }

    private List<UserMissionModel> convertAdvert(List<AdvertDTO> advertList) {
        ArrayList dailyTaskList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(advertList)) {
            return dailyTaskList;
        }
        advertList.forEach(advertDTO -> {
            UserMissionModel userMissionModel = new UserMissionModel();
            userMissionModel.setAction(advertDTO.getCopy());
            userMissionModel.setHeadImg(advertDTO.getIconUrl());
            userMissionModel.setName(advertDTO.getTaskMaintitle());
            userMissionModel.setRemark(advertDTO.getTaskSubtitle());
            userMissionModel.setAddress(advertDTO.getAddress());
            userMissionModel.setType(UserMissionModel.ADVERT_TASK);
            userMissionModel.setId(advertDTO.getId());
            dailyTaskList.add(userMissionModel);
        });
        return dailyTaskList;
    }

    private Boolean checkPost(LocationFacadeDTO locationFacadeDTO) {
        if (locationFacadeDTO == null || locationFacadeDTO.getEnableCommunityContent() == 0) {
            return false;
        }
        return true;
    }

    private Boolean checkVipAcvation(Long userId, LocationFacadeDTO locationFacadeDTO) {
        if (this.vipService.checkUserVip(userId) || this.isShowVipTask(locationFacadeDTO)) {
            return true;
        }
        return false;
    }

    private void checkVipActivation(UserMissionModel model, Long userId, String areaCode) {
        if (this.vipService.checkUserVip(userId) || this.isShowVipTask(userId, areaCode)) {
            model.setCompleted(Boolean.valueOf(true));
        } else {
            model.setCompleted(Boolean.valueOf(false));
        }
    }

    private LocationFacadeDTO getLocation(Long userId, String areaCode) {
        LocationFacadeDTO locationDTO = null;
        if (StringUtils.isNotEmpty((CharSequence)areaCode)) {
            locationDTO = this.locationFacadeService.getLocationByCode(areaCode);
        } else {
            LocationDetailDTO locationDetailDTO = this.getLocationByUser(this.userIntegrationService.selectByPrimaryKey(userId));
            if (null != locationDetailDTO) {
                locationDTO = new LocationFacadeDTO();
                BeanUtils.copyProperties((Object)locationDetailDTO, (Object)locationDTO);
            }
        }
        return locationDTO;
    }

    private boolean isShowVipTask(LocationFacadeDTO locationDTO) {
        if (locationDTO == null) {
            return false;
        }
        return 0 == locationDTO.getEnableVip();
    }

    private boolean isShowVipTask(Long userId, String areaCode) {
        LocationFacadeDTO locationDTO = this.getLocation(userId, areaCode);
        if (locationDTO == null) {
            return false;
        }
        return 0 == locationDTO.getEnableVip();
    }

    private LocationDetailDTO getLocationByUser(User user) {
        LocationDetailDTO locationDetailDTO = null;
        if (user != null) {
            String adcode = user.getLocationCode();
            if (null != adcode) {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties((Object)this.locationFacadeService.getLocationDetailByCode(adcode), (Object)locationDetailDTO);
            } else {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties((Object)this.locationFacadeService.getLocationDetailByCode(this.bizConfigProperties.getLocationCode()), (Object)locationDetailDTO);
            }
        }
        return locationDetailDTO;
    }

    public Json<BaskInfoMeta> baskInfo(Long userId) {
        BigDecimal totalCash = this.userAccountIntegrationService.getUserTotalCash(userId);
        BaskInfoMeta meta = new BaskInfoMeta();
        meta.setInviteCode(userId);
        meta.setTotalCoin(totalCash);
        return ResultUtil.genSuccessResult((Object)meta);
    }

    public void compleDailyTask(Long userId, Byte taskId) {
        Assert.notNull((Object)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info(LogMarker.BIZ, "[{}]\u5b8c\u6210\u4e86\u4efb\u52a1[{}]", (Object)userId, (Object)taskId);
        KeyGenerator key = this.getDailyTaskCacheKey(userId);
        this.redisHashMapAdapter.put(key, taskId.toString(), (Object)1);
        this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private KeyGenerator getDailyTaskCacheKey(Long userId) {
        return RedisConfig.DAILY_TASK_COMPELE_STATUS.copy().setKey(DateUtils.formatDate((Date)new Date()) + userId);
    }

    public Map<String, Byte> getDailyTaskStatus(Long userId) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Map result = this.redisHashMapAdapter.entries(this.getDailyTaskCacheKey(userId), Byte.class);
        if (result == null) {
            result = Maps.newHashMap();
        }
        return result;
    }

    public Long completeTask(Long userId, TaskEnum taskEnum, String relationId) {
        int num;
        logger.debug("\u7528\u6237[{}]\u5b8c\u6210\u4efb\u52a1\u7c7b\u578b[{}]---\u5efa\u7acb\u9080\u8bf7\u5173\u7cfb[{}]", new Object[]{userId, taskEnum.name(), relationId});
        Long reward = null;
        DailyTask dailyTask = this.dailyTaskMapper.selectByName(taskEnum.getDesc());
        if (dailyTask == null) {
            return null;
        }
        if (TaskStateEnum.ENABLE != TaskStateEnum.isAble((int)dailyTask.getState().byteValue())) {
            return null;
        }
        TaskTypeEnum taskType = TaskTypeEnum.getTaskType((int)dailyTask.getType().byteValue());
        if (TaskTypeEnum.NOVICE == taskType) {
            NoviceTaskRecord noviceTaskRecord = this.noviceTaskRecordMapper.findSelectiveByTaskName(taskEnum.getDesc(), userId);
            if (noviceTaskRecord == null) {
                noviceTaskRecord = this.createNoviceTask(dailyTask.getId(), userId);
                this.noviceTaskRecordMapper.insertSelective(noviceTaskRecord);
            } else {
                if (noviceTaskRecord.getState() == 1) {
                    return null;
                }
                noviceTaskRecord.setState(Byte.valueOf((byte)1));
                this.noviceTaskRecordMapper.updateByPrimaryKeySelective(noviceTaskRecord);
            }
            logger.info("\u6dfb\u52a0\u7528\u6237[{}]\u8d26\u6237\u7684\u91d1\u5e01\u548c\u6d41\u6c34,\u91d1\u5e01[{}], \u5efa\u7acb\u5173\u7cfb\u7684id\uff1a[{}]", new Object[]{userId, reward, relationId});
            AccountGoldParam param = new AccountGoldParam(userId, "USABLE_GOLD", Boolean.valueOf(true), Integer.valueOf(dailyTask.getReward().intValue()), Long.valueOf(relationId == null ? noviceTaskRecord.getId().longValue() : Long.valueOf(relationId).longValue()), taskEnum.name());
            this.addUserGold(param);
            this.pushMsgSupplyFeignService.pushMsg(this.getPushMsgByTask(userId, dailyTask));
            return dailyTask.getReward().longValue();
        }
        if (TaskTypeEnum.DAILY == taskType && (num = dailyTask.getNumber().intValue()) != 0) {
            boolean isPush = false;
            boolean isOverNumLimit = false;
            if (num == -1) {
                isPush = true;
            } else if (num > 0) {
                KeyGenerator taskCompleteNumKey = null;
                switch (taskEnum) {
                    case TASK_NEWS_READ: {
                        taskCompleteNumKey = RedisConfig.NEWS_READ.copy().setKey(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
                        break;
                    }
                    case TASK_NEWS_SHARE: {
                        taskCompleteNumKey = RedisConfig.TASK_SHARE_NEWS_NUM.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
                        break;
                    }
                    case TASK_VIDEO_READ: {
                        taskCompleteNumKey = RedisConfig.VIDEO_READ_NUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                        break;
                    }
                    case TASK_POST_INTIVATION: 
                    case TASK_FIRST_POST_INTIVATION: {
                        taskCompleteNumKey = RedisConfig.POST_FORUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                        break;
                    }
                    default: {
                        logger.error("TASK-ERR--userId:" + userId + ",taskName:" + taskEnum.name());
                    }
                }
                Integer completeNum = this.redisStringAdapter.getInt(taskCompleteNumKey);
                if (completeNum == null) {
                    completeNum = 0;
                }
                if (completeNum < num) {
                    isOverNumLimit = false;
                    Integer n = completeNum;
                    Integer n2 = completeNum = Integer.valueOf(completeNum + 1);
                    this.redisStringAdapter.set(taskCompleteNumKey, (Object)completeNum);
                    this.redisStringAdapter.expire(taskCompleteNumKey, (long)DateUtils.getCurSeconds());
                    if (completeNum == num) {
                        isPush = true;
                        this.compleDailyTask(userId, taskEnum.getType());
                    }
                } else {
                    isOverNumLimit = true;
                }
            } else {
                logger.error("TASK-NUMBER-ERR--userId:" + userId + ",taskName:" + taskEnum.name());
            }
            KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy().setKey(userId + ":" + DateUtils.formatDate((Date)new Date()));
            Integer totalGoldDay = this.redisStringAdapter.getInt(userRewardSumKey);
            boolean isOverGoldPerLimit = totalGoldDay != null && (totalGoldDay == null || totalGoldDay.compareTo(this.newsProperties.getGoldPerDay()) >= 0);
            if (!isOverGoldPerLimit && !isOverNumLimit) {
                this.redisStringAdapter.incrementWithDefault(userRewardSumKey, dailyTask.getReward().longValue(), dailyTask.getReward().intValue());
                this.redisStringAdapter.expire(userRewardSumKey, (long)DateUtils.getCurSeconds());
                reward = dailyTask.getReward().longValue();
                logger.info("\u6dfb\u52a0\u7528\u6237[{}]\u8d26\u6237\u7684\u91d1\u5e01\u548c\u6d41\u6c34,\u91d1\u5e01[{}], \u5efa\u7acb\u5173\u7cfb\u7684id\uff1a[{}]", new Object[]{userId, reward, relationId});
                AccountGoldParam param = new AccountGoldParam(userId, "USABLE_GOLD", Boolean.valueOf(true), Integer.valueOf(dailyTask.getReward().intValue()), relationId == null ? null : Long.valueOf(relationId), taskEnum.name());
                this.addUserGold(param);
            }
            if (isPush && !isOverGoldPerLimit) {
                this.pushMsgSupplyFeignService.pushMsg(this.getPushMsgByTask(userId, dailyTask));
            }
        }
        return reward;
    }

    private void addUserGold(AccountGoldParam param) {
        String relationId;
        String requestId = this.sequenceCreater.nextStringId();
        String string = relationId = param.getRelationId() == null ? "null" : param.getRelationId().toString();
        if (this.distributedLock.lock(param.getUserId() + relationId, requestId)) {
            this.userAccountIntegrationService.addGold(param);
            this.distributedLock.unlock(param.getUserId() + relationId, requestId);
        }
    }

    private PushMessage getPushMsgByTask(Long userId, DailyTask dailyTask) {
        String title = "\u4efb\u52a1\u5b8c\u6210";
        Integer goldBalance = this.userAccountIntegrationService.getUserUsableGold(userId);
        String content = "\u606d\u559c\u4f60\u6210\u529f\u5b8c\u6210\u4e86\u3010" + dailyTask.getName() + "\u3011,\u83b7\u5f97" + dailyTask.getReward().longValue() + "\u91d1\u5e01\u76ee\u524d\u5171\u6709" + goldBalance + "\u91d1\u5e01";
        return PushMessage.build().setTitle(title).setContent(content).setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId)).setPayloadInfo(PushPayloadInfo.build((PushMessageEnum)TaskEnum.getPushMessageEnumByDesc((String)dailyTask.getName())).addExtend("activityName", (Object)dailyTask.getName()).addExtend("activityReward", (Object)(dailyTask.getReward().longValue() + "")).addExtend("totalGold", (Object)(goldBalance + "")));
    }

    private MissionModel sortResult(MissionModel retModel) {
        this.sortList(retModel.getNewbieTaskList());
        this.sortList(retModel.getDailyTaskList());
        return retModel;
    }

    private void sortList(List<UserMissionModel> list) {
        list.sort(Comparator.comparingInt(UserMissionModel::getNewbiewTaskState));
    }

    private NoviceTaskRecord createNoviceTask(Long taskId, Long userId) {
        NoviceTaskRecord noviceTaskRecord = new NoviceTaskRecord();
        noviceTaskRecord.setState(Byte.valueOf((byte)1));
        noviceTaskRecord.setTaskId(taskId);
        noviceTaskRecord.setUserId(userId);
        Date now = new Date();
        noviceTaskRecord.setCreateTime(now);
        noviceTaskRecord.setUpdateTime(now);
        return noviceTaskRecord;
    }
}

