/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.domain.SignConfigMapper;
import com.bxm.localnews.activity.domain.SignRecordMapper;
import com.bxm.localnews.activity.dto.SignWarper;
import com.bxm.localnews.activity.service.SignFacadeService;
import com.bxm.localnews.activity.service.SignService;
import com.bxm.localnews.activity.vo.SignConfig;
import com.bxm.localnews.activity.vo.SignRecord;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignServiceImpl
extends BaseService
implements SignService,
SignFacadeService {
    private static final Logger logger = LoggerFactory.getLogger(SignServiceImpl.class);
    private static final int EXPIRE_TIME = 172800;
    private static final int SIGN_LIST_LENGTH = 8;
    @Resource
    private SignConfigMapper signConfigMapper;
    @Resource
    private SignRecordMapper signRecordMapper;
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private DistributedLock distributedLock;

    public SignWarper listSignRecord(Long userId, int platform) {
        SignWarper warper = new SignWarper();
        Date today = new Date();
        List<SignRecord> signRecords = this.buildSignList(0, today, userId, true);
        warper.setAutoSign(true);
        warper.setTodaySignState(true);
        warper.setSignReward(Long.valueOf(0L));
        warper.setTotalGold(BigDecimal.valueOf(this.userAccountIntegrationService.getUserUsableGold(userId).intValue()));
        warper.setRecords(signRecords);
        warper.setCount((long)this.getSignCount(userId));
        return warper;
    }

    private List<SignRecord> getLastSignRecordsByDoDailySign(Long userId, List<SignRecord> signRecords) {
        logger.debug("\u6267\u884c\u7b7e\u5230:[{}]", (Object)userId);
        Date today = new Date();
        for (SignRecord record : signRecords) {
            if (!org.apache.commons.lang3.time.DateUtils.isSameDay((Date)record.getSignDate(), (Date)today) || !record.getSignFlag().booleanValue()) continue;
            logger.debug("\u91cd\u590d\u7b7e\u5230:[{}]", (Object)userId);
            return signRecords;
        }
        this.saveSignRecord(userId);
        for (SignRecord cacheRecord : signRecords) {
            if (!org.apache.commons.lang3.time.DateUtils.isSameDay((Date)cacheRecord.getSignDate(), (Date)today)) continue;
            cacheRecord.setSignFlag(Boolean.valueOf(true));
            break;
        }
        this.redisStringAdapter.set(this.getSignListKey(userId), signRecords, 172800L);
        return signRecords;
    }

    private KeyGenerator getSignCountKey(Long userId) {
        return RedisConfig.SIGN_COUNT_KEY.copy().appendKey((Object)userId.toString());
    }

    private KeyGenerator getSignListKey(Long userId) {
        return RedisConfig.SIGN_LIST_KEY.copy().appendKey((Object)userId.toString());
    }

    private int getSignCount(Long userId) {
        Integer count = this.redisStringAdapter.getInt(this.getSignCountKey(userId));
        return count == null ? 1 : count;
    }

    private void resetSignCount(Long userId) {
        this.redisStringAdapter.set(this.getSignCountKey(userId), 0L);
    }

    private SignRecord saveSignRecord(Long userId) {
        SignRecord lastRecord = this.signRecordMapper.getLastSignRecord(userId);
        if (lastRecord != null && org.apache.commons.lang3.time.DateUtils.isSameDay((Date)lastRecord.getSignDate(), (Date)new Date())) {
            return lastRecord;
        }
        long reward = this.getSignReward(userId);
        Long count = this.redisStringAdapter.increment(this.getSignCountKey(userId));
        logger.debug("\u7b7e\u5230\u6210\u529f\uff0c\u5f53\u524d\u5929\u6570\uff1a[{}]", (Object)userId, (Object)count);
        SignRecord record = new SignRecord();
        record.setSignDate(new Date());
        record.setSignReward(Long.valueOf(reward));
        record.setSignDay(Integer.valueOf(count.intValue()));
        record.setUserId(userId);
        this.signRecordMapper.insertSelective(record);
        AccountGoldParam param = new AccountGoldParam(userId, "USABLE_GOLD", Boolean.valueOf(true), Integer.valueOf((int)reward), record.getId(), "SIGN_DAILY");
        this.userAccountIntegrationService.addGold(param);
        return record;
    }

    private long getSignReward(Long userId) {
        List<SignConfig> signConfigs = this.getSignconfigInfo();
        int count = this.getSignCount(userId);
        if (count >= 8) {
            return signConfigs.get(7).getReward();
        }
        return signConfigs.get(count).getReward();
    }

    private boolean getLastUnSignRecord(List<SignRecord> records) {
        if (records.get(records.size() - 1).getSignFlag().booleanValue()) {
            return true;
        }
        SignRecord lastRecord = records.stream().filter(signRecord -> signRecord.getSignFlag() == false).findFirst().get();
        Date today = new Date();
        return null != lastRecord && (org.apache.commons.lang3.time.DateUtils.isSameDay((Date)today, (Date)lastRecord.getSignDate()) || org.apache.commons.lang3.time.DateUtils.isSameDay((Date)DateUtils.addField((Date)lastRecord.getSignDate(), (int)5, (int)-1), (Date)today));
    }

    private List<SignRecord> listUserSignRecord(Long userId) {
        boolean isSequential;
        Date today = new Date();
        TypeReference<List<SignRecord>> typeReference = new TypeReference<List<SignRecord>>(){};
        List<SignRecord> records = (List<SignRecord>)this.redisStringAdapter.get(this.getSignListKey(userId), (TypeReference)typeReference);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            SignRecord lastRecord = (SignRecord)records.get(records.size() - 1);
            if (org.apache.commons.lang3.time.DateUtils.isSameDay((Date)DateUtils.addField((Date)lastRecord.getSignDate(), (int)5, (int)1), (Date)today)) {
                records = this.buildSignList(this.getSignCount(userId) + 1, today, userId, true);
            } else if (!this.getLastUnSignRecord(records)) {
                records = this.buildSignList(0, today, userId, true);
                this.resetSignCount(userId);
            }
            return records;
        }
        SignRecord record = this.signRecordMapper.getLastSignRecord(userId);
        boolean bl = isSequential = record != null && (org.apache.commons.lang3.time.DateUtils.isSameDay((Date)today, (Date)record.getSignDate()) || org.apache.commons.lang3.time.DateUtils.isSameDay((Date)DateUtils.addField((Date)record.getSignDate(), (int)5, (int)1), (Date)today));
        if (isSequential) {
            records = this.buildSignList(this.getSignCount(userId), record.getSignDate(), userId, false);
        } else {
            records = this.buildSignList(0, today, userId, true);
            this.resetSignCount(userId);
        }
        return records;
    }

    private List<SignRecord> buildSignList(int startIndex, Date startDate, Long userId, boolean newList) {
        ArrayList records = Lists.newArrayList();
        List<SignConfig> signConfigs = this.getSignconfigInfo();
        int startNum = startIndex > 8 ? (startIndex - 1) / 8 * 8 : 0;
        int actulStartIndex = startIndex % 8;
        if (startIndex > 0 && actulStartIndex == 0) {
            actulStartIndex = 8;
        } else if (startIndex == 0) {
            actulStartIndex = 1;
        }
        for (int i = 0; i < 8; ++i) {
            SignRecord record = new SignRecord();
            int signDay = i + 1 + startNum;
            record.setSignDay(Integer.valueOf(signDay));
            if (startIndex == 0) {
                record.setSignDate(DateUtils.addField((Date)startDate, (int)5, (int)i));
            } else {
                record.setSignDate(DateUtils.addField((Date)startDate, (int)5, (int)(i + 1 - actulStartIndex)));
            }
            if (newList) {
                record.setSignFlag(Boolean.valueOf(false));
            } else {
                record.setSignFlag(Boolean.valueOf(startIndex >= signDay));
            }
            if (signDay >= 8) {
                record.setSignReward(signConfigs.get(7).getReward());
            } else {
                record.setSignReward(signConfigs.get(i).getReward());
            }
            records.add(record);
        }
        this.redisStringAdapter.set(this.getSignListKey(userId), (Object)records, 172800L);
        return records;
    }

    public List<SignConfig> getSignconfigInfo() {
        TypeReference<List<SignConfig>> typeReference = new TypeReference<List<SignConfig>>(){};
        List redisRet = (List)this.redisStringAdapter.get(RedisConfig.SIGN_CACHE_KEY, (TypeReference)typeReference);
        if (CollectionUtils.isNotEmpty((Collection)redisRet)) {
            return redisRet;
        }
        List list = this.signConfigMapper.listAll();
        this.redisStringAdapter.set(RedisConfig.SIGN_CACHE_KEY, (Object)list, 604800L);
        return list;
    }
}

