package com.bxm.localnews.activity.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@Data
@ConfigurationProperties("activity.config")
public class ActivityProperties {

    /**
     * 设备验证token
     */
    private String machineToken;

    /**
     * 设备接入码
     */
    private String machineEncodingAESKey;

    /**
     * 机器对应的appid
     */
    private String machineAppId;

    /**
     * 分享到朋友圈的拉新图片的原图
     */
    private String shareSourceImgUrl;

    /**
     * 百度AI AppId
     */
    private String baiduAiAppId;

    /**
     * 百度AI API KEY
     */
    private String baiduAiApiKey;

    /**
     * 百度AI SecretKey
     */
    private String baiduAiSecretKey;

}
