package com.bxm.localnews.activity.record.convert;

import java.io.File;

/**
 * 录音类型转换，将原始文件类型转换为百度AIP支持的格式
 * @author liujia
 */
public interface IConverter {

    /**
     * 支持转换的原始类型
     * @return 支持的原始类型
     */
    String support();

    /**
     * 转换后的录音类型
     * @return 录音格式，如pcm、wav、mp3等
     */
    String after();

    /**
     * 执行文件转换
     * @param sourceFile 原始文件
     * @return 转换后的文件
     */
    File convert(File sourceFile);
}
