package com.bxm.localnews.activity.record.download;

import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;

/**
 * oss 文件下载
 * @author liujia
 */
@Component
public class OSSDownloader {

    private OKHttpService okHttpService;

    private BizConfigProperties bizConfigProperties;

    private SequenceCreater sequenceCreater;

    @Autowired
    public OSSDownloader(OKHttpService okHttpService, BizConfigProperties bizConfigProperties,
                         SequenceCreater sequenceCreater) {
        this.okHttpService = okHttpService;
        this.bizConfigProperties = bizConfigProperties;
        this.sequenceCreater = sequenceCreater;
    }

    public File download(String url) {
        if (StringUtils.isBlank(url)) {
            return null;
        }

        String filePath = bizConfigProperties.getTempDir() + sequenceCreater.nextStringId() + "." + getFileExtend(url);
        okHttpService.download(url, filePath);
        return new File(filePath);
    }

    private String getFileExtend(String url) {
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        if (fileName.contains("?")) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        return FileUtils.getFilextension(fileName);
    }
}
