package com.bxm.localnews.activity.service.redpacket.command;

import com.bxm.localnews.activity.dto.ScoreDto;
import com.bxm.localnews.activity.vo.GradeResultBean;

/**
 * @ClassName CommandGradeService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/30 16:13
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/30 16:13
 **/
public interface CommandGradeService {

    /**
     * 打分
     * @param commandUrl 口令oss地址
     * @param length 口令长度
     * @return
     */
    ScoreDto grade(String target, String commandUrl, Integer length);

    /**
     * 打分(站外)
     * @param mediaId 微信音频id
     * @return
     */
    ScoreDto grade(String target,String mediaId);

    /**
     * 测试本地文件录音评分接口
     * @date: 2019/4/26
     * @param content
     * @param path
     * @return java.lang.Object
     * @throws
     */
    GradeResultBean testRecord(String content, String path, Integer len);

}
