package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.record.grade.GradeProcesser;
import com.bxm.localnews.activity.record.parser.RecordParser;
import com.bxm.localnews.activity.service.redpacket.command.RecordGradeService;
import com.bxm.localnews.activity.vo.GradeResultBean;
import com.bxm.localnews.activity.vo.RecordGradeContext;
import com.bxm.localnews.activity.vo.RecordInfoBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;

@Service
public class RecordGradeServiceImpl implements RecordGradeService {

    private final RecordParser recordParser;

    private GradeProcesser gradeProcesser;

    @Autowired
    public RecordGradeServiceImpl(RecordParser recordParser, GradeProcesser gradeProcesser) {
        this.recordParser = recordParser;
        this.gradeProcesser = gradeProcesser;
    }

    @Override
    public GradeResultBean getByUrl(String target, String url, int duration) {
        RecordInfoBean recordInfo = recordParser.parse(url, duration);
        return process(recordInfo, target);
    }

    @Override
    public GradeResultBean getByLocal(String target, File recordFile, int duration) {
        RecordInfoBean recordInfo = recordParser.parse(recordFile, duration);
        return process(recordInfo, target);
    }

    @Override
    public GradeResultBean getByWx(String target, String mediaId) {
        RecordInfoBean recordInfo = recordParser.parse(mediaId);
        return process(recordInfo, target);
    }

    /**
     * 对录音结果进行评分处理
     * @param recordInfo 处理后的录音信息
     * @param target     目标文案
     * @return 评分结果
     */
    private GradeResultBean process(RecordInfoBean recordInfo, String target) {
        RecordGradeContext context = new RecordGradeContext();
        context.setDuration(recordInfo.getDuration());
        context.setTarget(target);
        context.setResult(recordInfo.getContent());
        context.setOssUrl(recordInfo.getOssUrl());

        return gradeProcesser.grade(context);
    }
}
