package com.bxm.localnews.activity.strategy;

import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import java.util.Collection;

@Service
public class TaskStrategyContext  extends BaseService implements InitializingBean, ApplicationContextAware{

    private Collection<TaskStrategy> strategyList;

    private ApplicationContext applicationContext;

    public NewsMissionRewardDto chooseStrategy(TaskContext taskContext) {
        for (TaskStrategy strategy : strategyList) {
            if (strategy.support(taskContext.getTaskEnum())) {
                return strategy.process(taskContext);
            }
        }

        return NewsMissionRewardDto.buildDefaultRewardDto();
    }

    @Override
    public void afterPropertiesSet() {
        strategyList = applicationContext.getBeansOfType(TaskStrategy.class).values();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
