package com.bxm.localnews.activity.strategy.newbieConcreteStrategy;

import com.bxm.localnews.activity.command.TransferAddGoldCommand;
import com.bxm.localnews.activity.domain.NoviceTaskRecordMapper;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.strategy.AbstractTaskStrategy;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.activity.vo.NoviceTaskRecord;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.vo.Message;
import com.gexin.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 新手任务处理策略
 * @author shentao
 */
public abstract class AbstractNewbieTaskStrategy extends AbstractTaskStrategy {

    @Autowired
    private NoviceTaskRecordMapper noviceTaskRecordMapper;

    @Override
    protected Message preProcessing(TaskContext taskContext) {
        // 判断新手能否完成，如果已经完成的新手则及时推出
        NoviceTaskRecord noviceTaskRecord = noviceTaskRecordMapper.findSelectiveByTaskType(taskContext.getTaskEnum().getType(), taskContext.getUserId());
        if (noviceTaskRecord != null && noviceTaskRecord.getState() == NoviceTaskRecord.FINISHED) {
            return Message.build(false, "新手任务已完成!");
        }
        taskContext.addParam("noviceTaskRecord", noviceTaskRecord);
        return Message.build(true);
    }

    @Override
    protected void postProcessing(TaskContext taskContext) {
        //新手任务都有金币增加和消息推送
        this.afterCompleteToAddGold(taskContext);

        //仅当任务需要推送时触发
        if (taskContext.getPushMsg() || taskContext.getPersistenceMsg()) {
            this.afterCompleteToPushMsg(taskContext);
        }

        if (taskContext.getUserEvent()) {
            this.afterCompleteToUserEvent(taskContext);
        }
    }

    /**
     * 新手任务默认实现方式
     * @param taskContext 任务上下文
     * @return 新手任务奖励信息
     */
    protected NewsMissionRewardDto defaultProcess(TaskContext taskContext) {
        Long userId = taskContext.getUserId();
        DailyTask dailyTask = taskContext.getDailyTask();
        //完成新手任务
        NoviceTaskRecord noviceTaskRecord = taskContext.getParam("noviceTaskRecord");
        if (noviceTaskRecord == null) {
            noviceTaskRecord = createNoviceTask(dailyTask.getId(), userId);
            logger.info("完成新手任务,任务信息为:[{}]", JSON.toJSONString(noviceTaskRecord));
            this.noviceTaskRecordMapper.insertSelective(noviceTaskRecord);
        } else {
            noviceTaskRecord.setState(NoviceTaskRecord.FINISHED);
            logger.info("更新新手任务为完成,任务信息为:[{}]", JSON.toJSONString(noviceTaskRecord));
            this.noviceTaskRecordMapper.updateByPrimaryKeySelective(noviceTaskRecord);
        }

        taskContext.addParam("noviceTaskRecordId", noviceTaskRecord.getId());
        return convertTask(taskContext.getTaskEnum(), (long) dailyTask.getReward().intValue(), userId);
    }

    /**
     * 新手任务拼装金币增加参数
     */
    private void afterCompleteToAddGold(TaskContext taskContext) {
        //添加金币
        Long noviceTaskRecordId = taskContext.getParam("noviceTaskRecordId");
        AccountGoldParam param = AccountGoldParam.buildAccountGoldParam(
                taskContext.getUserId(),
                taskContext.getDailyTask().getReward().intValue(),
                taskContext.getRelationId() == null ? noviceTaskRecordId : Long.valueOf(taskContext.getRelationId()),
                taskContext.getTaskEnum().name(), taskContext.getContent());
        TransferAddGoldCommand transferAddGoldCommand = TransferAddGoldCommand.buildTransferAddGoldCommand(param);
        taskInvokeThreadLocal.get().setCommand(transferAddGoldCommand);
    }

    /**
     * 创建新手任务并且设置完成
     * @param taskId 任务ID
     * @param userId 用户ID
     * @return 新手任务信息
     */
    private NoviceTaskRecord createNoviceTask(Long taskId, Long userId) {
        NoviceTaskRecord noviceTaskRecord = new NoviceTaskRecord();
        noviceTaskRecord.setState(NoviceTaskRecord.FINISHED);
        noviceTaskRecord.setTaskId(taskId);
        noviceTaskRecord.setUserId(userId);
        Date now = new Date();
        noviceTaskRecord.setCreateTime(now);
        noviceTaskRecord.setUpdateTime(now);
        return noviceTaskRecord;
    }
}
