package com.bxm.localnews.activity.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @ClassName NumberUtil
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/26 11:25
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/26 11:25
 **/
public class AmountUtil {
    /**
     * 保留两位小数,返回BigDecimal
     * @param bigDecimal
     * @return
     */
    public static BigDecimal halfUpScale2(BigDecimal bigDecimal) {
        if (null == bigDecimal){
            return null;
        }
        return bigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
    }
    /**
     * 四舍五入向上取整
     * @param bigDecimal
     * @return
     */
    public static Integer halfUptIntValue(BigDecimal bigDecimal) {
        if (null == bigDecimal){
            return null;
        }
        return bigDecimal.setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
    }
    /**
     * 四舍五入向上取整
     * @param bigDecimal
     * @return
     */
    public static String halfUptStringValue(BigDecimal bigDecimal) {
        if (null == bigDecimal){
            return null;
        }
        return bigDecimal.setScale(0, BigDecimal.ROUND_HALF_UP).toString();
    }

    /**
     * 四舍五入保留两位小数,返回String
     * convertMoney
     * @param bigDecimal
     * @return
     */
    public static String halfUpScale2StringValue(BigDecimal bigDecimal){
        if (null == bigDecimal){
            return null;
        }
        return halfUpScale2(bigDecimal).toString();
    }


    public static BigDecimal divideHalfUpScale4(BigDecimal dividend , BigDecimal divisor){
        return dividend.divide(divisor,4, RoundingMode.HALF_UP);
    }
    /**
     * 计算实际奖励金额
     * @param amount 红包总金额
     * @param expectNum 预计发放数量
     * @param score 口令综合评分
     *
     * 分值范围：40-100，奖励金额范围：0.4*红包均值-1.6*红包均值
     * 红包均值=红包总额/设定个数
     * 奖励金额=红包均值+(分值-70)/30*0.6*红包均值          奖励金额保留2位小数
     * 若奖励金额大于红包余额，则发放红包余额
     * @return
     */
    public static BigDecimal calculateRewardAmount(BigDecimal amount,Integer expectNum,Integer score) {
        BigDecimal averageAmount = divideHalfUpScale4(amount,new BigDecimal(expectNum));// 红包均值
        BigDecimal rewardAmount = averageAmount.add(divideHalfUpScale4(new BigDecimal(score - 70),new BigDecimal(30)).multiply(averageAmount).multiply(new BigDecimal(0.6)));// 奖励金额
        // 限定奖励金最大最小值范围
        BigDecimal maxRewardAmount = averageAmount.multiply(new BigDecimal(1.6));
        BigDecimal minRewardAmount = averageAmount.multiply(new BigDecimal(0.4));
        rewardAmount = rewardAmount.compareTo(minRewardAmount) < 0 ? minRewardAmount : rewardAmount;
        rewardAmount = rewardAmount.compareTo(maxRewardAmount) > 0 ? maxRewardAmount : rewardAmount;

        // 保留两位小数
        return AmountUtil.halfUpScale2(rewardAmount);
    }


}
