package com.bxm.localnews.activity.vo;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;

/**
 * 评分最终结果,包含不同评分策略的得分和综合得分
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Slf4j
public class GradeResultBean extends BaseBean {

    /**
     * 综合得分(最终采用的得分)
     */
    private int compositeScore;

    /**
     * 语速得分
     */
    private float speedScore;

    /**
     * 普通话中文匹配度得分
     */
    private float matchScore;

    /**
     * 拼音匹配得分
     */
    private float pinyinScore;

    /**
     * 语句顺序评分
     */
    private float sequenceScore;

    /**
     * 语音时长
     */
    private Integer length;

    /**
     * 语音oss地址
     */
    private String ossUrl;

    /**
     * 获取综合得分
     * @return 综合得分
     */
    public float calCompositeScore() {
        if (compositeScore == 0) {
            float score = 0F;
            //中文匹配小于60分，采用不同的分数比例
            if (matchScore < 60) {
                score += 0.3 * matchScore;
                score += 0.2 * ((matchScore + sequenceScore + pinyinScore) / 3);
                score += 0.4 * pinyinScore;
                score += 0.1 * speedScore / 100 * ((matchScore + sequenceScore + pinyinScore) / 3);
            } else {
                score += 0.5 * matchScore;
                score += 0.2 * ((matchScore + sequenceScore + pinyinScore) / 3);
                score += 0.3 * ((matchScore + sequenceScore + pinyinScore) / 3) * speedScore / 100;
            }
            //向上取整
            compositeScore = Math.round(score);

            if (log.isDebugEnabled()) {
                log.debug("matchScore:[{}],speedScore:[{}],pinyinScore:[{}],sequenceScore:[{}],compositeScore:[{}]",
                        matchScore, speedScore, pinyinScore, sequenceScore, compositeScore);
            }
        }

        return compositeScore;
    }
}
