package com.bxm.localnews.activity.command;

import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.BaseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 任务完成后给用户加金币
 */
public class TransferAddGoldCommand extends BaseBean implements TaskCommand{

    private static final Logger logger = LoggerFactory.getLogger(TransferAddGoldCommand.class);

    private AccountGoldParam accountGoldParam;

    public void setAccountGoldParam(AccountGoldParam accountGoldParam) {
        this.accountGoldParam = accountGoldParam;
    }

    public static TransferAddGoldCommand buildTransferAddGoldCommand(AccountGoldParam accountGoldParam){
        TransferAddGoldCommand transferAddGoldCommand = new TransferAddGoldCommand();
        transferAddGoldCommand.setAccountGoldParam(accountGoldParam);
        return transferAddGoldCommand;
    }

    @Override
    public void execute() {
        SequenceCreater sequenceCreater = SpringContextHolder.getBean(SequenceCreater.class);
        DistributedLock distributedLock = SpringContextHolder.getBean(DistributedLock.class);
        UserAccountIntegrationService userAccountIntegrationService = SpringContextHolder.getBean(UserAccountIntegrationService.class);

        String requestId = sequenceCreater.nextStringId();
        String relationId = accountGoldParam.getRelationId() == null ? "null" : accountGoldParam.getRelationId().toString();
        //防止多次同时添加金币
        if (distributedLock.lock(accountGoldParam.getUserId() + relationId, requestId)) {
            logger.info("【任务完成后】为用户增加金币,参数为:[{}]", accountGoldParam);
            userAccountIntegrationService.addGold(accountGoldParam);
            distributedLock.unlock(accountGoldParam.getUserId() + relationId, requestId);
        }
    }


}
