package com.bxm.localnews.activity.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 原有的h5地址中 /ba/ 的配置化
 * @author gonzo
 * @date 2020-08-03 21:09
 **/
@Component
@Data
@ConfigurationProperties("activity.config.ba")
public class BaConfig {

    /**
     * 首页的弹窗地址
     */
    private String homeWindowUrl = "/ba/appHelpPopup";

    /**
     * 助力成功地址
     */
    private String successAddress = "/ba/successHelp";

    /**
     * 二维码跳转地址
     */
    private String jumpAddress = "/ba/wxHome";

    /**
     * 帖子跳转地址
     */
    private String postAddress = "/ba/appHome";

    /**
     * 蓝天救援队分享地址
     */
    private String blueSkySharePage = "/ba/successHelp";
}
